/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.IOException;
import org.infinispan.CacheException;
import org.infinispan.marshall.jboss.AbstractJBossMarshaller;
import org.infinispan.marshall.jboss.DefaultContextClassResolver;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

public class GenericJBossMarshaller
extends AbstractJBossMarshaller {
    private ThreadLocal<Marshaller> marshallerTL = new ThreadLocal<Marshaller>(){

        @Override
        protected Marshaller initialValue() {
            try {
                return GenericJBossMarshaller.this.factory.createMarshaller(GenericJBossMarshaller.this.baseCfg);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
    };
    private ThreadLocal<Unmarshaller> unmarshallerTL = new ThreadLocal<Unmarshaller>(){

        @Override
        protected Unmarshaller initialValue() {
            try {
                return GenericJBossMarshaller.this.factory.createUnmarshaller(GenericJBossMarshaller.this.baseCfg);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
    };

    public GenericJBossMarshaller() {
        this.baseCfg.setClassResolver((ClassResolver)new DefaultContextClassResolver(this.getClass().getClassLoader()));
    }

    @Override
    protected Marshaller getMarshaller(boolean isReentrant) throws IOException {
        Marshaller marshaller;
        Marshaller marshaller2 = marshaller = isReentrant ? this.factory.createMarshaller(this.baseCfg) : this.marshallerTL.get();
        if (log.isTraceEnabled()) {
            log.tracef("Start marshaller after retrieving marshaller from %s", (Object)(isReentrant ? "factory" : "thread local"));
        }
        return marshaller;
    }

    @Override
    protected Unmarshaller getUnmarshaller(boolean isReentrant) throws IOException {
        Unmarshaller unmarshaller;
        Unmarshaller unmarshaller2 = unmarshaller = isReentrant ? this.factory.createUnmarshaller(this.baseCfg) : this.unmarshallerTL.get();
        if (log.isTraceEnabled()) {
            log.tracef("Start unmarshaller after retrieving marshaller from %s", (Object)(isReentrant ? "factory" : "thread local"));
        }
        return unmarshaller;
    }
}

