/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.deployment.scanner.Attribute;
import org.jboss.as.server.deployment.scanner.DeploymentScannerAdd;
import org.jboss.as.server.deployment.scanner.DeploymentScannerLogger;
import org.jboss.as.server.deployment.scanner.DeploymentScannerRemove;
import org.jboss.as.server.deployment.scanner.DeploymentScannerSubsystemAdd;
import org.jboss.as.server.deployment.scanner.DeploymentScannerSubsystemRemove;
import org.jboss.as.server.deployment.scanner.DeploymentSubsystemDescriptions;
import org.jboss.as.server.deployment.scanner.Element;
import org.jboss.as.server.deployment.scanner.Namespace;
import org.jboss.as.server.deployment.scanner.WriteAutoDeployExplodedAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteAutoDeployZipAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteDeploymentTimeoutAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteEnabledAttributeHandler;
import org.jboss.as.server.deployment.scanner.WritePathAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteRelativeToAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteScanIntervalAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DeploymentScannerExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "deployment-scanner";
    private static final PathElement scannersPath = PathElement.pathElement((String)"scanner");
    private static final DeploymentScannerParser parser = new DeploymentScannerParser();
    private static final String DEFAULT_SCANNER_NAME = "default";
    private static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return DeploymentSubsystemDescriptions.getSubsystemDescription(locale);
        }
    };
    private static final DescriptionProvider SCANNER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return DeploymentSubsystemDescriptions.getScannerDescription(locale);
        }
    };

    public void initialize(ExtensionContext context) {
        DeploymentScannerLogger.ROOT_LOGGER.debug("Initializing Deployment Scanner Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)DeploymentScannerSubsystemAdd.INSTANCE, (DescriptionProvider)DeploymentScannerSubsystemAdd.INSTANCE, false);
        registration.registerOperationHandler("remove", (OperationStepHandler)DeploymentScannerSubsystemRemove.INSTANCE, (DescriptionProvider)DeploymentScannerSubsystemRemove.INSTANCE, false);
        ManagementResourceRegistration scanners = registration.registerSubModel(scannersPath, SCANNER);
        scanners.registerOperationHandler("add", (OperationStepHandler)DeploymentScannerAdd.INSTANCE, (DescriptionProvider)DeploymentScannerAdd.INSTANCE, false);
        scanners.registerOperationHandler("remove", (OperationStepHandler)DeploymentScannerRemove.INSTANCE, (DescriptionProvider)DeploymentScannerRemove.INSTANCE, false);
        scanners.registerReadWriteAttribute(Attribute.PATH.getLocalName(), null, (OperationStepHandler)WritePathAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        scanners.registerReadWriteAttribute(Attribute.RELATIVE_TO.getLocalName(), null, (OperationStepHandler)WriteRelativeToAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        scanners.registerReadWriteAttribute(Attribute.SCAN_ENABLED.getLocalName(), null, (OperationStepHandler)WriteEnabledAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        scanners.registerReadWriteAttribute(Attribute.SCAN_INTERVAL.getLocalName(), null, (OperationStepHandler)WriteScanIntervalAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        scanners.registerReadWriteAttribute(Attribute.AUTO_DEPLOY_ZIPPED.getLocalName(), null, (OperationStepHandler)WriteAutoDeployZipAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        scanners.registerReadWriteAttribute(Attribute.AUTO_DEPLOY_EXPLODED.getLocalName(), null, (OperationStepHandler)WriteAutoDeployExplodedAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        scanners.registerReadWriteAttribute(Attribute.DEPLOYMENT_TIMEOUT.getLocalName(), null, (OperationStepHandler)WriteDeploymentTimeoutAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)parser);
    }

    static class DeploymentScannerParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        DeploymentScannerParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode scanners = context.getModelNode();
            for (Property list : scanners.asPropertyList()) {
                ModelNode node = list.getValue();
                for (Property scanner : node.asPropertyList()) {
                    writer.writeEmptyElement(Element.DEPLOYMENT_SCANNER.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), scanner.getName());
                    ModelNode configuration = scanner.getValue();
                    if (configuration.hasDefined("path")) {
                        writer.writeAttribute(Attribute.PATH.getLocalName(), configuration.get("path").asString());
                    }
                    if (configuration.hasDefined("scan-enabled")) {
                        writer.writeAttribute(Attribute.SCAN_ENABLED.getLocalName(), configuration.get("scan-enabled").asString());
                    }
                    if (configuration.hasDefined("scan-interval")) {
                        writer.writeAttribute(Attribute.SCAN_INTERVAL.getLocalName(), configuration.get("scan-interval").asString());
                    }
                    if (configuration.hasDefined("relative-to")) {
                        writer.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), configuration.get("relative-to").asString());
                    }
                    if (configuration.hasDefined("auto-deploy-zipped") && !configuration.get("auto-deploy-zipped").asBoolean()) {
                        writer.writeAttribute(Attribute.AUTO_DEPLOY_ZIPPED.getLocalName(), Boolean.FALSE.toString());
                    }
                    if (configuration.hasDefined("auto-deploy-exploded") && configuration.get("auto-deploy-exploded").asBoolean()) {
                        writer.writeAttribute(Attribute.AUTO_DEPLOY_EXPLODED.getLocalName(), Boolean.TRUE.toString());
                    }
                    if (!configuration.hasDefined("deployment-timeout")) continue;
                    writer.writeAttribute(Attribute.DEPLOYMENT_TIMEOUT.getLocalName(), configuration.get("deployment-timeout").asString());
                }
                writer.writeEndElement();
            }
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode address = new ModelNode();
            address.add("subsystem", DeploymentScannerExtension.SUBSYSTEM_NAME);
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            block6: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DEPLOYMENT_SCANNER_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case DEPLOYMENT_SCANNER: {
                                this.parseScanner(reader, address, list);
                                continue block6;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        void parseScanner(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
            Boolean enabled = null;
            Integer interval = null;
            String path = null;
            String name = DeploymentScannerExtension.DEFAULT_SCANNER_NAME;
            String relativeTo = null;
            Boolean autoDeployZipped = null;
            Boolean autoDeployExploded = null;
            Long deploymentTimeout = null;
            int attrCount = reader.getAttributeCount();
            block10: for (int i = 0; i < attrCount; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case PATH: {
                        path = value;
                        continue block10;
                    }
                    case NAME: {
                        name = value;
                        continue block10;
                    }
                    case RELATIVE_TO: {
                        relativeTo = value;
                        continue block10;
                    }
                    case SCAN_INTERVAL: {
                        interval = Integer.parseInt(value);
                        continue block10;
                    }
                    case SCAN_ENABLED: {
                        enabled = Boolean.parseBoolean(value);
                        continue block10;
                    }
                    case AUTO_DEPLOY_ZIPPED: {
                        autoDeployZipped = Boolean.parseBoolean(value);
                        continue block10;
                    }
                    case AUTO_DEPLOY_EXPLODED: {
                        autoDeployExploded = Boolean.parseBoolean(value);
                        continue block10;
                    }
                    case DEPLOYMENT_TIMEOUT: {
                        deploymentTimeout = Long.parseLong(value);
                        continue block10;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
            }
            if (path == null) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("path"));
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            operation.get("address").set(address).add("scanner", name);
            operation.get("path").set(path);
            if (interval != null) {
                operation.get("scan-interval").set(interval.intValue());
            }
            if (autoDeployZipped != null) {
                operation.get("auto-deploy-zipped").set(autoDeployZipped.booleanValue());
            }
            if (autoDeployExploded != null) {
                operation.get("auto-deploy-exploded").set(autoDeployExploded.booleanValue());
            }
            if (enabled != null) {
                operation.get("scan-enabled").set(enabled.booleanValue());
            }
            if (relativeTo != null) {
                operation.get("relative-to").set(relativeTo);
            }
            if (deploymentTimeout != null) {
                operation.get("deployment-timeout").set(deploymentTimeout.longValue());
            }
            list.add(operation);
        }
    }
}

