/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ejb3.component.EjbComponentInstance;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.WrappedRemoteException;
import org.jboss.as.ejb3.context.EntityContextImpl;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class EntityBeanComponentInstance
extends EjbComponentInstance {
    private volatile Object primaryKey;
    private volatile boolean isDiscarded;
    private volatile EntityContextImpl entityContext;
    private volatile boolean removed = false;
    private volatile boolean synchronizeRegistered;
    private final Interceptor ejbStore;
    private final Interceptor ejbActivate;
    private final Interceptor ejbLoad;
    private final Interceptor ejbPassivate;

    protected EntityBeanComponentInstance(BasicComponent component, AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors) {
        super(component, instanceReference, preDestroyInterceptor, methodInterceptors, Collections.<Method, Interceptor>emptyMap());
        EntityBeanComponent ejbComponent = (EntityBeanComponent)component;
        this.ejbStore = ejbComponent.createInterceptor(ejbComponent.getEjbStore());
        this.ejbActivate = ejbComponent.createInterceptor(ejbComponent.getEjbActivate());
        this.ejbLoad = ejbComponent.createInterceptor(ejbComponent.getEjbLoad());
        this.ejbPassivate = ejbComponent.createInterceptor(ejbComponent.getEjbPassivate());
    }

    @Override
    public EntityBeanComponent getComponent() {
        return (EntityBeanComponent)super.getComponent();
    }

    public EntityBean getInstance() {
        return (EntityBean)super.getInstance();
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public void discard() {
        if (!this.isDiscarded) {
            this.isDiscarded = true;
            this.getComponent().getCache().discard(this);
            this.primaryKey = null;
        }
    }

    public void destroy() {
        try {
            this.getInstance().unsetEntityContext();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        super.destroy();
    }

    public synchronized void associate(Object primaryKey) {
        this.primaryKey = primaryKey;
        try {
            InterceptorContext context = this.prepareInterceptorContext();
            EntityBeanComponent component = this.getComponent();
            Method ejbActivateMethod = component.getEjbActivateMethod();
            context.setMethod(ejbActivateMethod);
            this.ejbActivate.processInvocation(context);
            InterceptorContext loadContext = this.prepareInterceptorContext();
            loadContext.setMethod(component.getEjbLoadMethod());
            this.ejbLoad.processInvocation(loadContext);
        }
        catch (RemoteException e) {
            throw new WrappedRemoteException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void store() {
        try {
            if (!this.removed) {
                InterceptorContext context = this.prepareInterceptorContext();
                EntityBeanComponent component = this.getComponent();
                context.setMethod(component.getEjbStoreMethod());
                this.ejbStore.processInvocation(context);
            }
        }
        catch (RemoteException e) {
            throw new WrappedRemoteException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void passivate() {
        try {
            if (!this.removed) {
                InterceptorContext context = this.prepareInterceptorContext();
                EntityBeanComponent component = this.getComponent();
                context.setMethod(component.getEjbPassivateMethod());
                this.ejbPassivate.processInvocation(context);
            }
        }
        catch (RemoteException e) {
            throw new WrappedRemoteException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setupContext() {
        try {
            EntityContextImpl entityContext = new EntityContextImpl(this);
            this.setEjbContext(entityContext);
            this.getInstance().setEntityContext((EntityContext)entityContext);
        }
        catch (RemoteException e) {
            throw new WrappedRemoteException(e);
        }
    }

    @Override
    public EntityContextImpl getEjbContext() {
        return this.entityContext;
    }

    protected void setEjbContext(EntityContextImpl entityContext) {
        this.entityContext = entityContext;
    }

    public EJBObject getEjbObject() {
        Object pk = this.getPrimaryKey();
        if (pk == null) {
            throw new IllegalStateException("Cannot call getEjbObject before the object is associated with a primary key");
        }
        return this.getComponent().getEJBObject(pk);
    }

    public EJBLocalObject getEjbLocalObject() {
        Object pk = this.getPrimaryKey();
        if (pk == null) {
            throw new IllegalStateException("Cannot call getEjbLocalObject before the object is associated with a primary key");
        }
        return this.getComponent().getEjbLocalObject(pk);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public synchronized void setSynchronizationRegistered(boolean synchronizeRegistered) {
        this.synchronizeRegistered = synchronizeRegistered;
    }

    public synchronized boolean isSynchronizeRegistered() {
        return this.synchronizeRegistered;
    }
}

