/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.interceptors;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanHomeCreateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class EntityBeanEjbCreateMethodInterceptorFactory
implements InterceptorFactory {
    public static final EntityBeanEjbCreateMethodInterceptorFactory INSTANCE = new EntityBeanEjbCreateMethodInterceptorFactory();

    protected EntityBeanEjbCreateMethodInterceptorFactory() {
    }

    public Interceptor create(InterceptorFactoryContext context) {
        final Object existing = context.getContextData().get(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
        final AtomicReference primaryKeyReference = new AtomicReference();
        context.getContextData().put(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, primaryKeyReference);
        final Method ejbCreate = (Method)context.getContextData().get(EntityBeanHomeCreateInterceptorFactory.EJB_CREATE_METHOD_KEY);
        final Method ejbPostCreate = (Method)context.getContextData().get(EntityBeanHomeCreateInterceptorFactory.EJB_POST_CREATE_METHOD_KEY);
        final Object[] params = (Object[])context.getContextData().get(EntityBeanHomeCreateInterceptorFactory.PARAMETERS_KEY);
        return new Interceptor(){

            public Object processInvocation(InterceptorContext context) throws Exception {
                if (existing != null) {
                    primaryKeyReference.set(existing);
                    return context.proceed();
                }
                Component component = (Component)context.getPrivateData(Component.class);
                if (!(component instanceof EntityBeanComponent)) {
                    throw EjbMessages.MESSAGES.unexpectedComponent(component, EntityBeanComponent.class);
                }
                final EntityBeanComponent entityBeanComponent = (EntityBeanComponent)component;
                final EntityBeanComponentInstance instance = entityBeanComponent.getPool().get();
                Object primaryKey = EntityBeanEjbCreateMethodInterceptorFactory.this.invokeEjbCreate(context, ejbCreate, instance, params);
                instance.associate(primaryKey);
                primaryKeyReference.set(primaryKey);
                entityBeanComponent.getCache().create(instance);
                EntityBeanEjbCreateMethodInterceptorFactory.this.invokeEjbPostCreate(context, ejbPostCreate, instance, params);
                TransactionSynchronizationRegistry transactionSynchronizationRegistry = entityBeanComponent.getTransactionSynchronizationRegistry();
                if (transactionSynchronizationRegistry.getTransactionKey() != null) {
                    transactionSynchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

                        public void beforeCompletion() {
                        }

                        public void afterCompletion(int status) {
                            if (status != 3) {
                                entityBeanComponent.getPool().release(instance);
                            }
                        }
                    });
                }
                return context.proceed();
            }
        };
    }

    protected void invokeEjbPostCreate(InterceptorContext context, Method ejbPostCreate, EntityBeanComponentInstance instance, Object[] params) throws Exception {
        ejbPostCreate.invoke((Object)instance.getInstance(), params);
    }

    protected Object invokeEjbCreate(InterceptorContext context, Method ejbCreate, EntityBeanComponentInstance instance, Object[] params) throws Exception {
        return ejbCreate.invoke((Object)instance.getInstance(), params);
    }
}

