/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateless;

import java.lang.reflect.Method;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.interceptors.ComponentTypeIdentityInterceptorFactory;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.PoolConfigService;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.session.StatelessRemoteViewInstanceFactory;
import org.jboss.as.ejb3.component.stateless.StatelessComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.stateless.StatelessComponentInstanceAssociatingFactory;
import org.jboss.as.ejb3.component.stateless.StatelessSessionBeanObjectViewConfigurator;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponentCreateService;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.tx.EjbBMTInterceptor;
import org.jboss.as.ejb3.tx.TimerCMTTxInterceptor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class StatelessComponentDescription
extends SessionBeanComponentDescription {
    private String poolConfigName;

    public StatelessComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbModuleDescription, ServiceName deploymentUnitServiceName) {
        super(componentName, componentClassName, ejbModuleDescription, deploymentUnitServiceName);
    }

    public ComponentConfiguration createConfiguration(ClassIndex classIndex, ClassLoader moduleClassLoder) {
        ComponentConfiguration statelessComponentConfiguration = new ComponentConfiguration((ComponentDescription)this, classIndex, moduleClassLoder);
        statelessComponentConfiguration.setComponentCreateServiceFactory((ComponentCreateServiceFactory)new StatelessComponentCreateServiceFactory());
        StatelessComponentDescription statelessComponentDescription = (StatelessComponentDescription)statelessComponentConfiguration.getComponentDescription();
        statelessComponentConfiguration.getCreateDependencies().add(new PoolInjectingConfigurator(statelessComponentDescription));
        if (TransactionManagementType.BEAN.equals((Object)this.getTransactionManagementType())) {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.addComponentInterceptor(EjbBMTInterceptor.FACTORY, 1024, false);
                    configuration.addTimeoutInterceptor(EjbBMTInterceptor.FACTORY, 1024);
                }
            });
        } else {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.addTimeoutInterceptor(TimerCMTTxInterceptor.FACTORY, 1040);
                }
            });
        }
        return statelessComponentConfiguration;
    }

    @Override
    public boolean allowsConcurrentAccess() {
        return false;
    }

    @Override
    public SessionBeanComponentDescription.SessionBeanType getSessionBeanType() {
        return SessionBeanComponentDescription.SessionBeanType.STATELESS;
    }

    @Override
    protected void setupViewInterceptors(EJBViewDescription view) {
        EJBViewDescription ejbViewDescription;
        super.setupViewInterceptors(view);
        view.getConfigurators().addFirst(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                for (Method method : configuration.getProxyFactory().getCachedMethods()) {
                    if ((!method.getName().equals("hashCode") || method.getParameterTypes().length != 0) && (!method.getName().equals("equals") || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Object.class)) continue;
                    configuration.addClientInterceptor(method, (InterceptorFactory)ComponentTypeIdentityInterceptorFactory.INSTANCE, 1024);
                }
                configuration.addViewInterceptor((InterceptorFactory)StatelessComponentInstanceAssociatingFactory.instance(), 1792);
            }
        });
        if (view instanceof EJBViewDescription && (ejbViewDescription = view).getMethodIntf() == MethodIntf.REMOTE) {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    String earApplicationName = componentConfiguration.getComponentDescription().getModuleDescription().getEarApplicationName();
                    configuration.setViewInstanceFactory((ViewInstanceFactory)new StatelessRemoteViewInstanceFactory(earApplicationName, componentConfiguration.getModuleName(), componentConfiguration.getComponentDescription().getModuleDescription().getDistinctName(), componentConfiguration.getComponentName()));
                }
            });
        }
    }

    @Override
    protected ViewConfigurator getSessionBeanObjectViewConfigurator() {
        return StatelessSessionBeanObjectViewConfigurator.INSTANCE;
    }

    public boolean isTimerServiceApplicable() {
        return true;
    }

    public void setPoolConfigName(String poolConfigName) {
        this.poolConfigName = poolConfigName;
    }

    public String getPoolConfigName() {
        return this.poolConfigName;
    }

    private class PoolInjectingConfigurator
    implements DependencyConfigurator<Service<Component>> {
        private final StatelessComponentDescription statelessComponentDescription;

        PoolInjectingConfigurator(StatelessComponentDescription statelessComponentDescription2) {
            this.statelessComponentDescription = statelessComponentDescription2;
        }

        public void configureDependency(ServiceBuilder<?> serviceBuilder, Service<Component> service) throws DeploymentUnitProcessingException {
            StatelessSessionComponentCreateService statelessSessionComponentService = (StatelessSessionComponentCreateService)service;
            String poolName = this.statelessComponentDescription.getPoolConfigName();
            if (poolName == null) {
                serviceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, PoolConfigService.DEFAULT_SLSB_POOL_CONFIG_SERVICE_NAME, PoolConfig.class, statelessSessionComponentService.getPoolConfigInjector());
            } else {
                serviceBuilder.addDependency(PoolConfigService.EJB_POOL_CONFIG_BASE_SERVICE_NAME.append(new String[]{poolName}), PoolConfig.class, statelessSessionComponentService.getPoolConfigInjector());
            }
        }
    }
}

