/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jacorb.deployment.JacORBDeploymentMarker;
import org.jboss.as.jacorb.service.CorbaORBService;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.omg.CORBA.ORB;

public class ORBJndiBindingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        if (!JacORBDeploymentMarker.isJacORBDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) || DeploymentTypeMarker.isType((DeploymentType)DeploymentType.APPLICATION_CLIENT, (DeploymentUnit)deploymentUnit)) {
            ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
            this.bindService(serviceTarget, moduleContextServiceName);
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (component.getNamingMode() != ComponentNamingMode.CREATE) continue;
            ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName(), (String)component.getComponentName());
            this.bindService(serviceTarget, compContextServiceName);
        }
    }

    private void bindService(ServiceTarget serviceTarget, ServiceName contextServiceName) {
        ServiceName userTransactionServiceName = contextServiceName.append(new String[]{"ORB"});
        BinderService userTransactionBindingService = new BinderService("ORB");
        serviceTarget.addService(userTransactionServiceName, (Service)userTransactionBindingService).addDependency(CorbaORBService.SERVICE_NAME, ORB.class, (Injector)new ManagedReferenceInjector(userTransactionBindingService.getManagedObjectInjector())).addDependency(contextServiceName, ServiceBasedNamingStore.class, userTransactionBindingService.getNamingStoreInjector()).install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

