/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.entity;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.EJBComponentDescriptionFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EntityBeanMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.msc.service.ServiceName;

public class EntityBeanComponentDescriptionFactory
extends EJBComponentDescriptionFactory {
    private static final Logger logger = Logger.getLogger(EntityBeanComponentDescriptionFactory.class);
    private final boolean appclient;

    public EntityBeanComponentDescriptionFactory(boolean appclient) {
        this.appclient = appclient;
    }

    protected void mark(DeploymentUnit deploymentUnit) {
    }

    @Override
    protected void processAnnotations(DeploymentUnit deploymentUnit, CompositeIndex compositeIndex) throws DeploymentUnitProcessingException {
    }

    @Override
    protected void processBeanMetaData(DeploymentUnit deploymentUnit, EnterpriseBeanMetaData enterpriseBeanMetaData) throws DeploymentUnitProcessingException {
        if (enterpriseBeanMetaData instanceof EntityBeanMetaData) {
            this.processEntityBeanMetaData(deploymentUnit, (EntityBeanMetaData)enterpriseBeanMetaData);
        }
    }

    private void processEntityBeanMetaData(DeploymentUnit deploymentUnit, EntityBeanMetaData entity) throws DeploymentUnitProcessingException {
        String remote;
        String home;
        String local;
        EjbJarDescription ejbJarDescription = EntityBeanComponentDescriptionFactory.getEjbJarDescription(deploymentUnit);
        String beanName = entity.getName();
        String beanClassName = entity.getEjbClass();
        if (!this.shouldProcess(entity)) {
            return;
        }
        this.mark(deploymentUnit);
        EntityBeanComponentDescription description = this.createDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName());
        description.setDeploymentDescriptorEnvironment(new DeploymentDescriptorEnvironment("java:comp/env/", (RemoteEnvironment)entity));
        if (this.appclient) {
            deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_RESOLVABLE_COMPONENTS, (Object)description);
        } else {
            ejbJarDescription.getEEModuleDescription().addComponent((ComponentDescription)description);
        }
        description.setDescriptorData((EnterpriseBeanMetaData)entity);
        description.setPersistenceType(entity.getPersistenceType());
        description.setReentrant(entity.isReentrant());
        description.setPrimaryKeyType(entity.getPrimKeyClass());
        String localHome = entity.getLocalHome();
        if (localHome != null) {
            description.addLocalHome(localHome);
        }
        if ((local = entity.getLocal()) != null) {
            description.addEjbLocalObjectView(local);
        }
        if ((home = entity.getHome()) != null) {
            description.addRemoteHome(home);
        }
        if ((remote = entity.getRemote()) != null) {
            description.addEjbObjectView(remote);
        }
    }

    protected boolean shouldProcess(EntityBeanMetaData entity) {
        return entity.isBMP();
    }

    protected EntityBeanComponentDescription createDescription(String beanName, String beanClassName, EjbJarDescription ejbJarDescription, ServiceName serviceName) {
        return new EntityBeanComponentDescription(beanName, beanClassName, ejbJarDescription, serviceName);
    }
}

