/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;
import org.jboss.modules.Module;

public class TransactionAttributeMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    public TransactionAttributeMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        this.processTransactionAttributeAnnotation(applicationClasses, deploymentReflectionIndex, componentClass, null, componentConfiguration);
        for (ViewDescription view : componentConfiguration.getViews()) {
            try {
                Class viewClass = module.getClassLoader().loadClass(view.getViewClassName());
                EJBViewDescription ejbView = (EJBViewDescription)view;
                this.processTransactionAttributeAnnotation(applicationClasses, deploymentReflectionIndex, viewClass, ejbView.getMethodIntf(), componentConfiguration);
            }
            catch (ClassNotFoundException e) {
                throw EjbMessages.MESSAGES.failToLoadEjbViewClass(e);
            }
        }
    }

    private void processTransactionAttributeAnnotation(EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MethodIntf methodIntf, EJBComponentDescription componentConfiguration) {
        RuntimeAnnotationInformation data = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, TransactionAttribute.class);
        for (Map.Entry entry : data.getClassAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            String className = methodIntf == null ? (String)entry.getKey() : null;
            componentConfiguration.setTransactionAttribute(methodIntf, className, (TransactionAttributeType)((List)entry.getValue()).get(0));
        }
        for (Map.Entry entry : data.getMethodAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            MethodIdentifier method = MethodIdentifier.getIdentifierForMethod((Method)((Method)entry.getKey()));
            componentConfiguration.setTransactionAttribute(methodIntf, (TransactionAttributeType)((List)entry.getValue()).get(0), ((Method)entry.getKey()).getDeclaringClass().getName(), method.getName(), method.getParameterTypes());
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        ContainerTransactionsMetaData containerTransactions;
        AssemblyDescriptorMetaData assemblyDescriptor;
        EjbJarMetaData ejbJarMetadata = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetadata != null && (assemblyDescriptor = ejbJarMetadata.getAssemblyDescriptor()) != null && (containerTransactions = assemblyDescriptor.getContainerTransactionsByEjbName(componentConfiguration.getEJBName())) != null) {
            for (ContainerTransactionMetaData containerTx : containerTransactions) {
                TransactionAttributeType txAttr = containerTx.getTransAttribute();
                MethodsMetaData methods = containerTx.getMethods();
                for (MethodMetaData method : methods) {
                    String methodName = method.getMethodName();
                    MethodIntf methodIntf = this.getMethodIntf(method.getMethodIntf());
                    if (methodName.equals("*")) {
                        componentConfiguration.setTransactionAttribute(methodIntf, null, txAttr);
                        continue;
                    }
                    MethodParametersMetaData methodParams = method.getMethodParams();
                    if (methodParams == null) {
                        componentConfiguration.setTransactionAttribute(methodIntf, txAttr, methodName);
                        continue;
                    }
                    componentConfiguration.setTransactionAttribute(methodIntf, txAttr, null, methodName, this.getMethodParams(methodParams));
                }
            }
        }
    }
}

