/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.UserTransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.ejb.client.remoting.RemotingAttachments;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

class EJBRemoteTransactionPropogatingInterceptor
implements Interceptor {
    private final EJBRemoteTransactionsRepository ejbRemoteTransactionsRepository;

    EJBRemoteTransactionPropogatingInterceptor(EJBRemoteTransactionsRepository ejbRemoteTransactionsRepository) {
        this.ejbRemoteTransactionsRepository = ejbRemoteTransactionsRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        byte[] transactionIDBytes;
        RemotingAttachments remotingAttachments = (RemotingAttachments)context.getPrivateData(RemotingAttachments.class);
        TransactionManager transactionManager = this.ejbRemoteTransactionsRepository.getTransactionManager();
        Transaction originatingRemoteTx = null;
        if (remotingAttachments != null && (transactionIDBytes = remotingAttachments.getPayloadAttachment(1)) != null) {
            TransactionID transactionID = TransactionID.createTransactionID((byte[])transactionIDBytes);
            if (transactionID instanceof UserTransactionID) {
                this.createOrResumeUserTransaction((UserTransactionID)transactionID);
            } else if (transactionID instanceof XidTransactionID) {
                this.createOrResumeXidTransaction((XidTransactionID)transactionID);
            }
            originatingRemoteTx = transactionManager.getTransaction();
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            if (originatingRemoteTx != null) {
                transactionManager.suspend();
            }
        }
    }

    private void createOrResumeUserTransaction(UserTransactionID userTransactionID) throws Exception {
        TransactionManager transactionManager = this.ejbRemoteTransactionsRepository.getTransactionManager();
        Transaction alreadyCreatedTx = this.ejbRemoteTransactionsRepository.getTransaction((TransactionID)userTransactionID);
        if (alreadyCreatedTx != null) {
            transactionManager.resume(alreadyCreatedTx);
        } else {
            UserTransaction userTransaction = this.ejbRemoteTransactionsRepository.getUserTransaction();
            userTransaction.begin();
            Transaction newlyCreatedTx = transactionManager.getTransaction();
            this.ejbRemoteTransactionsRepository.addTransaction((TransactionID)userTransactionID, newlyCreatedTx);
        }
    }

    private void createOrResumeXidTransaction(XidTransactionID xidTransactionID) throws Exception {
        TransactionManager transactionManager = this.ejbRemoteTransactionsRepository.getTransactionManager();
        Transaction alreadyCreatedTx = this.ejbRemoteTransactionsRepository.getTransaction((TransactionID)xidTransactionID);
        if (alreadyCreatedTx != null) {
            transactionManager.resume(alreadyCreatedTx);
        } else {
            SubordinateTransaction newSubOrdinateTx = SubordinationManager.getTransactionImporter().importTransaction(xidTransactionID.getXid(), 300);
            transactionManager.resume((Transaction)newSubOrdinateTx);
            this.ejbRemoteTransactionsRepository.addTransaction((TransactionID)xidTransactionID, (Transaction)newSubOrdinateTx);
        }
    }
}

