/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.ejb.EJBAccessException;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class SecurityContextInterceptor
implements Interceptor {
    private final PrivilegedAction<Void> pushAction;
    private final PrivilegedAction<Void> popAction;

    public SecurityContextInterceptor(final SimpleSecurityManager securityManager, final String securityDomain, final String runAs, final String runAsPrincipal, final Set<String> extraRoles) {
        this.pushAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    securityManager.push(securityDomain, runAs, runAsPrincipal, extraRoles);
                }
                catch (SecurityException e) {
                    throw new EJBAccessException(e.getMessage());
                }
                return null;
            }
        };
        this.popAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                securityManager.pop();
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        AccessController.doPrivileged(this.pushAction);
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            AccessController.doPrivileged(this.popAction);
        }
    }
}

