/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.timerservice.TimerHandleImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.persistence.TimerEntity;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.task.TimerTask;
import org.jboss.invocation.InterceptorContext;

public class TimerImpl
implements Timer {
    protected final String id;
    protected TimerState timerState;
    protected TimerServiceImpl timerService;
    protected TimedObjectInvoker timedObjectInvoker;
    protected Serializable info;
    protected boolean persistent;
    protected final TimerHandleImpl handle;
    protected Date initialExpiration;
    protected long intervalDuration;
    protected Date nextExpiration;
    protected Date previousRun;
    protected TimerEntity persistentState;

    public TimerImpl(String id, TimerServiceImpl service, Date initialExpiry, long intervalDuration, Serializable info, boolean persistent) {
        this(id, service, initialExpiry, intervalDuration, initialExpiry, info, persistent);
    }

    public TimerImpl(String id, TimerServiceImpl service, Date initialExpiry, long intervalDuration, Date nextEpiry, Serializable info, boolean persistent) {
        assert (service != null) : "service is null";
        assert (id != null) : "id is null";
        this.id = id;
        this.timerService = service;
        this.timedObjectInvoker = service.getInvoker();
        this.info = info;
        this.persistent = persistent;
        this.initialExpiration = initialExpiry;
        this.intervalDuration = intervalDuration;
        this.nextExpiration = nextEpiry;
        this.previousRun = null;
        this.handle = new TimerHandleImpl(this.id, this.timedObjectInvoker.getTimedObjectId(), service);
        this.setTimerState(TimerState.CREATED);
    }

    public TimerImpl(TimerEntity persistedTimer, TimerServiceImpl service) {
        this(persistedTimer.getId(), service, persistedTimer.getInitialDate(), persistedTimer.getInterval(), persistedTimer.getNextDate(), null, true);
        this.previousRun = persistedTimer.getPreviousRun();
        this.timerState = persistedTimer.getTimerState();
        this.info = persistedTimer.getInfo();
    }

    public String getId() {
        return this.id;
    }

    public boolean isCalendarTimer() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return false;
    }

    public void cancel() throws IllegalStateException, EJBException {
        Transaction currentTx;
        this.assertTimerState();
        if (this.timerState != TimerState.EXPIRED) {
            this.setTimerState(TimerState.CANCELED);
        }
        if ((currentTx = this.timerService.getTransaction()) == null) {
            this.cancelTimeout();
            this.timerService.persistTimer(this);
        } else {
            this.registerTimerCancellationWithTx(currentTx);
        }
    }

    public TimerHandle getHandle() throws IllegalStateException, EJBException {
        this.assertTimerState();
        if (!this.persistent) {
            throw EjbMessages.MESSAGES.invalidTimerHandlersForPersistentTimers("EJB3.1 Spec 18.2.6");
        }
        return this.handle;
    }

    public TimerHandle getTimerHandle() {
        return this.handle;
    }

    public boolean isPersistent() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return this.persistent;
    }

    public Serializable getInfo() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return this.info;
    }

    public Serializable getTimerInfo() {
        return this.info;
    }

    public Date getNextTimeout() throws IllegalStateException, EJBException {
        this.assertTimerState();
        if (this.nextExpiration == null) {
            throw EjbMessages.MESSAGES.noMoreTimeoutForTimer(this);
        }
        return this.nextExpiration;
    }

    public Date getNextExpiration() {
        return this.nextExpiration;
    }

    public void setNextTimeout(Date next) {
        this.nextExpiration = next;
    }

    public ScheduleExpression getSchedule() throws IllegalStateException, EJBException {
        this.assertTimerState();
        throw EjbMessages.MESSAGES.invalidTimerNotCalendarBaseTimer(this);
    }

    public long getTimeRemaining() throws IllegalStateException, EJBException {
        this.assertTimerState();
        if (this.nextExpiration == null) {
            throw EjbMessages.MESSAGES.noMoreTimeoutForTimer(this);
        }
        long currentTimeInMillis = System.currentTimeMillis();
        long nextTimeoutInMillis = this.nextExpiration.getTime();
        return nextTimeoutInMillis - currentTimeInMillis;
    }

    public boolean isAutoTimer() {
        return false;
    }

    protected void cancelTimeout() {
        this.timerService.cancelTimeout(this);
    }

    public Date getInitialExpiration() {
        return this.initialExpiration;
    }

    public long getInterval() {
        return this.intervalDuration;
    }

    public String getTimedObjectId() {
        return this.timerService.getInvoker().getTimedObjectId();
    }

    public TimerServiceImpl getTimerService() {
        return this.timerService;
    }

    public boolean isActive() {
        return this.timerService.isStarted() && !this.isCanceled() && !this.isExpired();
    }

    public boolean isCanceled() {
        return this.timerState == TimerState.CANCELED;
    }

    public boolean isExpired() {
        return this.timerState == TimerState.EXPIRED;
    }

    public boolean isInRetry() {
        return this.timerState == TimerState.RETRY_TIMEOUT;
    }

    public Date getPreviousRun() {
        return this.previousRun;
    }

    public void setPreviousRun(Date previousRun) {
        this.previousRun = previousRun;
    }

    public TimerState getState() {
        return this.timerState;
    }

    protected void assertTimerState() {
        if (this.timerState == TimerState.EXPIRED) {
            throw EjbMessages.MESSAGES.timerHasExpired();
        }
        if (this.timerState == TimerState.CANCELED) {
            throw EjbMessages.MESSAGES.timerWasCanceled();
        }
        InterceptorContext ctx = CurrentInvocationContext.get();
        if (ctx != null && ctx.getPrivateData(Component.class) instanceof StatefulSessionComponent && ctx.getMethod() == null) {
            throw new IllegalStateException("Timer methods may not be invoked from lifecycle methods of a stateful session bean");
        }
    }

    public void expireTimer() {
        EjbLogger.ROOT_LOGGER.debug("expireTimer: " + this);
        this.setTimerState(TimerState.EXPIRED);
        this.timerService.removeTimer(this);
        this.cancelTimeout();
    }

    public void setTimerState(TimerState state) {
        this.timerState = state;
    }

    public TimerEntity getPersistentState() {
        if (!this.persistent) {
            throw EjbMessages.MESSAGES.failToPersistTimer(this);
        }
        if (this.persistentState == null) {
            this.persistentState = this.createPersistentState();
        } else {
            this.persistentState.setNextDate(this.nextExpiration);
            this.persistentState.setPreviousRun(this.previousRun);
            this.persistentState.setTimerState(this.timerState);
        }
        return this.persistentState;
    }

    public void suspend() {
        this.cancelTimeout();
    }

    public void scheduleTimeout() {
        this.timerService.scheduleTimeout(this);
    }

    protected TimerEntity createPersistentState() {
        return new TimerEntity(this);
    }

    protected TimerTask<?> getTimerTask() {
        return new TimerTask<TimerImpl>(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.handle == null) {
            return false;
        }
        if (!(obj instanceof TimerImpl)) {
            return false;
        }
        TimerImpl otherTimer = (TimerImpl)obj;
        return this.handle.equals(otherTimer.getTimerHandle());
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[id=");
        sb.append(this.id);
        sb.append(" ");
        sb.append("timedObjectId=");
        if (this.timedObjectInvoker == null) {
            sb.append("null");
        } else {
            sb.append(this.timedObjectInvoker.getTimedObjectId());
        }
        sb.append(" ");
        sb.append("auto-timer?:");
        sb.append(this.isAutoTimer());
        sb.append(" ");
        sb.append("persistent?:");
        sb.append(this.persistent);
        sb.append(" ");
        sb.append("timerService=");
        sb.append(this.timerService);
        sb.append(" ");
        sb.append("initialExpiration=");
        sb.append(this.initialExpiration);
        sb.append(" ");
        sb.append("intervalDuration(in milli sec)=");
        sb.append(this.intervalDuration);
        sb.append(" ");
        sb.append("nextExpiration=");
        sb.append(this.nextExpiration);
        sb.append(" ");
        sb.append("timerState=");
        sb.append((Object)this.timerState);
        return sb.toString();
    }

    private void registerTimerCancellationWithTx(Transaction tx) {
        try {
            tx.registerSynchronization((Synchronization)new TimerCancellationTransactionSynchronization(this));
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.failToRegisterWithTxTimerCancellation(e);
        }
    }

    private Serializable deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStreamWithTCCL ois = new ObjectInputStreamWithTCCL(bais);
            return (Serializable)ois.readObject();
        }
        catch (IOException ioe) {
            throw EjbMessages.MESSAGES.failToDeserializeInfoInTimer(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw EjbMessages.MESSAGES.failToDeserializeInfoInTimer(cnfe);
        }
    }

    private class TimerCancellationTransactionSynchronization
    implements Synchronization {
        private TimerImpl timer;

        public TimerCancellationTransactionSynchronization(TimerImpl timer) {
            if (timer == null) {
                throw EjbMessages.MESSAGES.timerIsNull();
            }
            this.timer = timer;
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                EjbLogger.ROOT_LOGGER.debug("commit timer cancellation: " + this.timer);
                TimerState timerState = this.timer.getState();
                switch (timerState) {
                    case CANCELED: 
                    case IN_TIMEOUT: 
                    case RETRY_TIMEOUT: {
                        this.timer.cancelTimeout();
                        TimerImpl.this.timerService.persistTimer(this.timer);
                    }
                }
            } else if (status == 4) {
                EjbLogger.ROOT_LOGGER.debug("rollback timer cancellation: " + this.timer);
                TimerState timerState = this.timer.getState();
                switch (timerState) {
                    case CANCELED: {
                        this.timer.setTimerState(TimerState.ACTIVE);
                    }
                }
            }
        }

        public void beforeCompletion() {
        }
    }

    private final class ObjectInputStreamWithTCCL
    extends ObjectInputStream {
        public ObjectInputStreamWithTCCL(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            String className = v.getName();
            Class<?> resolvedClass = null;
            EjbLogger.ROOT_LOGGER.trace("Attempting to locate class [" + className + "]");
            try {
                resolvedClass = TimerImpl.this.timedObjectInvoker.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                resolvedClass = this.getClass().getClassLoader().loadClass(className);
            }
            return resolvedClass;
        }
    }
}

