/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;

class RootLoggerRemove
extends AbstractRemoveStepHandler {
    static final RootLoggerRemove INSTANCE = new RootLoggerRemove();
    static final String OPERATION_NAME = "remove-root-logger";

    RootLoggerRemove() {
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) {
        context.removeService(LogServices.ROOT_LOGGER);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.removeService(LogServices.ROOT_LOGGER);
        ModelNode rootLogger = operation.get("root-logger");
        ModelNode handlers = CommonAttributes.HANDLERS.validateOperation(rootLogger);
        if (handlers.isDefined()) {
            LogServices.uninstallLoggerHandlers(context, "ROOT", handlers);
        }
    }
}

