/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class GenericSubsystemDescribeHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final GenericSubsystemDescribeHandler INSTANCE = new GenericSubsystemDescribeHandler();

    protected GenericSubsystemDescribeHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode address = PathAddress.pathAddress(PathAddress.pathAddress(operation.require("address")).getLastElement()).toModelNode();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode result = context.getResult();
        this.describe(resource, address, result, context.getResourceRegistration());
        context.completeStep();
    }

    protected void describe(Resource resource, ModelNode address, ModelNode result, ImmutableManagementResourceRegistration registration) {
        if (resource == null || registration.isRemote() || registration.isRuntimeOnly() || resource.isProxy() || resource.isRuntime()) {
            return;
        }
        Set<PathElement> children = registration.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        result.add(this.createAddOperation(address, resource.getModel(), children));
        for (PathElement element : children) {
            if (element.isMultiTarget()) {
                String childType = element.getKey();
                for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                    ImmutableManagementResourceRegistration childRegistration = registration.getSubModel(PathAddress.pathAddress(PathElement.pathElement(childType, entry.getName())));
                    ModelNode childAddress = address.clone();
                    childAddress.add(childType, entry.getName());
                    this.describe(entry, childAddress, result, childRegistration);
                }
                continue;
            }
            Resource child = resource.getChild(element);
            ImmutableManagementResourceRegistration childRegistration = registration.getSubModel(PathAddress.pathAddress(element));
            ModelNode childAddress = address.clone();
            childAddress.add(element.getKey(), element.getValue());
            this.describe(child, childAddress, result, childRegistration);
        }
    }

    protected ModelNode createAddOperation(ModelNode address, ModelNode subModel, Set<PathElement> children) {
        ModelNode operation = subModel.clone();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        if (children != null && !children.isEmpty()) {
            for (PathElement path : children) {
                if (!subModel.hasDefined(path.getKey())) continue;
                subModel.remove(path.getKey());
            }
        }
        return operation;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getSubsystemDescribeOperation(locale);
    }
}

