/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.webapp.internal;

import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.spi.util.BundleContextHelper;
import org.ops4j.pax.web.extender.war.internal.WebAppPublisherExt;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

public class WebAppPublisherInterceptor
extends AbstractLifecycleInterceptor
implements LifecycleInterceptor {
    private static final Logger log = Logger.getLogger(WebAppPublisherInterceptor.class);
    private WebAppPublisherExt publisher;

    public WebAppPublisherInterceptor(WebAppPublisherExt publisher) {
        this.publisher = publisher;
        this.addInput(WebApp.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException {
        if (state == 8) {
            log.debug((Object)"Publish WebApp metadata");
            BundleContextHelper bcHelper = new BundleContextHelper(context.getSystemContext());
            ServiceReference sref = bcHelper.getServiceReference(HttpService.class.getName(), 5000);
            if (sref == null) {
                throw new IllegalStateException("HttpService not available");
            }
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            try {
                WebApp webApp = (WebApp)context.getAttachment(WebApp.class);
                this.publisher.publish(webApp);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ctxLoader);
            }
        }
        if (state == 16) {
            log.debug((Object)"Unpublish WebApp metadata");
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            try {
                WebApp webApp = (WebApp)context.getAttachment(WebApp.class);
                this.publisher.unpublish(webApp);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ctxLoader);
            }
        }
    }
}

