/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.webapp.internal;

import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.vfs.VirtualFile;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.parser.dom.DOMWebXmlParser;
import org.osgi.framework.Bundle;

public class WebXMLParserInterceptor
extends AbstractLifecycleInterceptor
implements LifecycleInterceptor {
    private static final Logger log = Logger.getLogger(WebXMLParserInterceptor.class);

    public WebXMLParserInterceptor() {
        this.addOutput(WebApp.class);
    }

    public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException {
        WebApp webApp = (WebApp)context.getAttachment(WebApp.class);
        if (webApp == null && state == 8) {
            try {
                VirtualFile root = context.getRoot();
                VirtualFile webXML = root.getChild("/WEB-INF/web.xml");
                if (webXML != null) {
                    webApp = this.createWebAppMetadata(context, webXML);
                    log.debugf("Attach web metadata: %s", (Object)webApp);
                    context.addAttachment(WebApp.class, (Object)webApp);
                }
            }
            catch (IOException ex) {
                throw new LifecycleInterceptorException("Cannot parse web.xml", (Throwable)ex);
            }
        }
    }

    private WebApp createWebAppMetadata(InvocationContext context, VirtualFile webXML) throws IOException {
        DOMWebXmlParser parser = new DOMWebXmlParser();
        WebApp webApp = parser.parse(webXML.openStream());
        Bundle bundle = context.getBundle();
        webApp.setBundle(bundle);
        String contextName = (String)bundle.getHeaders().get("Web-ContextPath");
        if (contextName == null) {
            contextName = bundle.getSymbolicName();
        }
        if ("/".equals(contextName.trim())) {
            contextName = "";
        }
        webApp.setContextName(contextName);
        webApp.setRootPath("");
        return webApp;
    }
}

