/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.ops4j.pax.web.extender.war.internal.WebAppHttpContext;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RegisterWebAppVisitorHS
implements WebAppVisitor {
    private static final Log LOG = LogFactory.getLog(RegisterWebAppVisitorHS.class);
    private final HttpService m_httpService;
    private HttpContext m_httpContext;
    private ClassLoader m_bundleClassLoader;

    RegisterWebAppVisitorHS(HttpService httpService) {
        NullArgumentException.validateNotNull((Object)httpService, (String)"Http Service");
        this.m_httpService = httpService;
    }

    @Override
    public void visit(WebApp webApp) {
        NullArgumentException.validateNotNull((Object)webApp, (String)"Web app");
        this.m_bundleClassLoader = new BundleClassLoader(webApp.getBundle());
        this.m_httpContext = new WebAppHttpContext(this.m_httpService.createDefaultHttpContext(), webApp.getRootPath(), webApp.getBundle(), webApp.getMimeMappings());
        try {
            LOG.info((Object)"Pax Web not available. Skipping context params registration");
            this.m_httpService.registerResources("/", "", this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error((Object)"Registration exception. Skipping.", ignore);
        }
    }

    @Override
    public void visit(WebAppServlet webAppServlet) {
        NullArgumentException.validateNotNull((Object)webAppServlet, (String)"Web app servlet");
        String[] aliases = webAppServlet.getAliases();
        if (aliases != null && aliases.length > 0) {
            for (String alias : aliases) {
                try {
                    Servlet servlet = RegisterWebAppVisitorHS.newInstance(Servlet.class, this.m_bundleClassLoader, webAppServlet.getServletClass());
                    this.m_httpService.registerServlet(alias, servlet, RegisterWebAppVisitorHS.convertInitParams(webAppServlet.getInitParams()), this.m_httpContext);
                }
                catch (Throwable ignore) {
                    LOG.error((Object)"Registration exception. Skipping.", ignore);
                }
            }
        } else {
            LOG.warn((Object)("Servlet [" + webAppServlet + "] does not have any alias. Skipped."));
        }
    }

    @Override
    public void visit(WebAppFilter webAppFilter) {
        LOG.info((Object)("Pax Web not available. Skipping filter registration for [" + webAppFilter + "]"));
    }

    @Override
    public void visit(WebAppListener webAppListener) {
        LOG.info((Object)("Pax Web not available. Skipping listener registration for [" + webAppListener + "]"));
    }

    @Override
    public void visit(WebAppErrorPage webAppErrorPage) {
        LOG.info((Object)("Pax Web not available. Skipping error page registration for [" + webAppErrorPage + "]"));
    }

    @Override
    public void visit(WebAppLoginConfig loginConfig) {
        LOG.info((Object)("Pax Web not available. Skipping listener registration for [" + loginConfig + "]"));
    }

    @Override
    public void visit(WebAppConstraintMapping constraintMapping) {
        LOG.info((Object)("Pax Web not available. Skipping listener registration for [" + constraintMapping + "]"));
    }

    public static <T> T newInstance(Class<T> clazz, ClassLoader classLoader, String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        NullArgumentException.validateNotNull(clazz, (String)"Class");
        NullArgumentException.validateNotNull((Object)classLoader, (String)"ClassLoader");
        NullArgumentException.validateNotNull((Object)className, (String)"Servlet Class");
        return (T)classLoader.loadClass(className).newInstance();
    }

    public static Dictionary convertInitParams(WebAppInitParam[] initParams) {
        if (initParams == null || initParams.length == 0) {
            return null;
        }
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        for (WebAppInitParam initParam : initParams) {
            dictionary.put(initParam.getParamName(), initParam.getParamValue());
        }
        return dictionary;
    }
}

