/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.ops4j.pax.web.extender.war.internal.RegisterWebAppVisitorHS;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.WebAppWebContainerContext;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppSecurityConstraint;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;

class RegisterWebAppVisitorWC
implements WebAppVisitor {
    private static final Log LOG = LogFactory.getLog(RegisterWebAppVisitorWC.class);
    private final WebContainer m_webContainer;
    private HttpContext m_httpContext;
    private ClassLoader m_bundleClassLoader;

    RegisterWebAppVisitorWC(WebContainer webContainer) {
        NullArgumentException.validateNotNull((Object)webContainer, (String)"Web container");
        this.m_webContainer = webContainer;
    }

    public void visit(WebApp webApp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("visiting webapp" + webApp));
        }
        NullArgumentException.validateNotNull((Object)webApp, (String)"Web app");
        this.m_bundleClassLoader = new BundleClassLoader(webApp.getBundle());
        this.m_httpContext = new WebAppWebContainerContext(this.m_webContainer.createDefaultHttpContext(), webApp.getRootPath(), webApp.getBundle(), webApp.getMimeMappings());
        webApp.setHttpContext(this.m_httpContext);
        try {
            this.m_webContainer.setContextParam(RegisterWebAppVisitorHS.convertInitParams(webApp.getContextParams()), this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error((Object)"Registration exception. Skipping.", ignore);
        }
        if (webApp.getLoginConfigs() != null) {
            for (WebAppLoginConfig loginConfig : webApp.getLoginConfigs()) {
                this.visit(loginConfig);
            }
        }
        if (webApp.getSessionTimeout() != null) {
            try {
                this.m_webContainer.setSessionTimeout(Integer.valueOf(Integer.parseInt(webApp.getSessionTimeout())), this.m_httpContext);
            }
            catch (Throwable ignore) {
                LOG.error((Object)"Registration exception. Skipping.", ignore);
            }
        }
        try {
            this.m_webContainer.registerResources("/", "default", this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error((Object)"Registration exception. Skipping.", ignore);
        }
        try {
            String[] welcomeFiles = webApp.getWelcomeFiles();
            if (welcomeFiles != null && welcomeFiles.length > 0) {
                this.m_webContainer.registerWelcomeFiles(welcomeFiles, true, this.m_httpContext);
            }
        }
        catch (Throwable ignore) {
            LOG.error((Object)"Registration exception. Skipping.", ignore);
        }
        try {
            this.m_webContainer.registerJsps(new String[]{"*.jsp", "*.jspx", "*.jspf", "*.xsp", "*.JSP", "*.JSPX", "*.JSPF", "*.XSP"}, this.m_httpContext);
        }
        catch (UnsupportedOperationException ignore) {
            LOG.warn((Object)ignore.getMessage());
        }
        catch (Throwable ignore) {
            LOG.error((Object)"Registration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppServlet webAppServlet) {
        NullArgumentException.validateNotNull((Object)webAppServlet, (String)"Web app servlet");
        String[] urlPatterns = webAppServlet.getAliases();
        if (urlPatterns == null || urlPatterns.length == 0) {
            LOG.warn((Object)("Servlet [" + webAppServlet + "] does not have any mapping. Skipped."));
        }
        try {
            Servlet servlet = RegisterWebAppVisitorHS.newInstance(Servlet.class, this.m_bundleClassLoader, webAppServlet.getServletClass());
            webAppServlet.setServlet(servlet);
            this.m_webContainer.registerServlet(servlet, urlPatterns, RegisterWebAppVisitorHS.convertInitParams(webAppServlet.getInitParams()), this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error((Object)"Registration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppFilter webAppFilter) {
        NullArgumentException.validateNotNull((Object)webAppFilter, (String)"Web app filter");
        String[] urlPatterns = webAppFilter.getUrlPatterns();
        String[] servletNames = webAppFilter.getServletNames();
        if (!(urlPatterns != null && urlPatterns.length != 0 || servletNames != null && servletNames.length != 0)) {
            LOG.warn((Object)("Filter [" + webAppFilter + "] does not have any mapping. Skipped."));
        }
        try {
            Filter filter = RegisterWebAppVisitorHS.newInstance(Filter.class, this.m_bundleClassLoader, webAppFilter.getFilterClass());
            webAppFilter.setFilter(filter);
            this.m_webContainer.registerFilter(filter, urlPatterns, servletNames, RegisterWebAppVisitorHS.convertInitParams(webAppFilter.getInitParams()), this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error((Object)"Registration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppListener webAppListener) {
        NullArgumentException.validateNotNull((Object)webAppListener, (String)"Web app listener");
        try {
            EventListener listener = RegisterWebAppVisitorHS.newInstance(EventListener.class, this.m_bundleClassLoader, webAppListener.getListenerClass());
            webAppListener.setListener(listener);
            this.m_webContainer.registerEventListener(listener, this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error((Object)"Registration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppErrorPage webAppErrorPage) {
        NullArgumentException.validateNotNull((Object)webAppErrorPage, (String)"Web app error page");
        try {
            this.m_webContainer.registerErrorPage(webAppErrorPage.getError(), webAppErrorPage.getLocation(), this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error((Object)"Registration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppLoginConfig loginConfig) {
        NullArgumentException.validateNotNull((Object)loginConfig, (String)"Web app login config");
        try {
            this.m_webContainer.registerLoginConfig(loginConfig.getAuthMethod(), loginConfig.getRealmName(), loginConfig.getFormLoginPage(), loginConfig.getFormErrorPage(), this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error((Object)"Registration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppConstraintMapping constraintMapping) {
        NullArgumentException.validateNotNull((Object)constraintMapping, (String)"Web app constraint mappings");
        try {
            WebAppSecurityConstraint securityConstraint = constraintMapping.getSecurityConstraint();
            this.m_webContainer.registerConstraintMapping(constraintMapping.getConstraintName(), constraintMapping.getUrl(), constraintMapping.getMapping(), securityConstraint.getDataConstraint(), securityConstraint.getAuthenticate(), securityConstraint.getRoles(), this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error((Object)"Registration exception. Skipping", ignore);
        }
    }
}

