/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;

public abstract class AbstractWriteAttributeHandler<T>
implements OperationStepHandler {
    private final ParametersValidator nameValidator = new ParametersValidator();
    private final ParameterValidator unresolvedValueValidator;
    private final ParameterValidator resolvedValueValidator;
    private final Map<String, AttributeDefinition> attributeDefinitions;

    protected AbstractWriteAttributeHandler() {
        this((ParameterValidator)null, (ParameterValidator)null);
    }

    protected AbstractWriteAttributeHandler(ParameterValidator validator) {
        this(validator, validator);
    }

    protected AbstractWriteAttributeHandler(AttributeDefinition ... definitions) {
        assert (definitions != null) : ControllerMessages.MESSAGES.nullVar("definitions").getLocalizedMessage();
        this.attributeDefinitions = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition def : definitions) {
            this.attributeDefinitions.put(def.getName(), def);
        }
        this.unresolvedValueValidator = null;
        this.resolvedValueValidator = null;
    }

    protected AbstractWriteAttributeHandler(ParameterValidator unresolvedValidator, ParameterValidator resolvedValidator) {
        this.nameValidator.registerValidator("name", new StringLengthValidator(1));
        this.unresolvedValueValidator = unresolvedValidator;
        this.resolvedValueValidator = resolvedValidator;
        this.attributeDefinitions = null;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.nameValidator.validate(operation);
        final String attributeName = operation.require("name").asString();
        final ModelNode newValue = operation.hasDefined("value") ? operation.get("value") : new ModelNode();
        this.validateUnresolvedValue(attributeName, newValue);
        final ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        final ModelNode currentValue = submodel.get(attributeName).clone();
        final AttributeDefinition attributeDefinition = this.getAttributeDefinition(attributeName);
        if (attributeDefinition != null) {
            ModelNode syntheticOp = new ModelNode();
            syntheticOp.get(attributeName).set(newValue);
            attributeDefinition.validateAndSet(syntheticOp, submodel);
        } else {
            submodel.get(attributeName).set(newValue);
        }
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode resolvedValue = attributeDefinition != null ? attributeDefinition.resolveModelAttribute(context, submodel) : newValue.resolve();
                    AbstractWriteAttributeHandler.this.validateResolvedValue(attributeName, newValue);
                    HandbackHolder handback = new HandbackHolder();
                    boolean restartRequired = AbstractWriteAttributeHandler.this.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handback);
                    if (restartRequired) {
                        context.reloadRequired();
                    }
                    if (context.completeStep() != OperationContext.ResultAction.KEEP) {
                        ModelNode valueToRestore = currentValue.resolve();
                        try {
                            AbstractWriteAttributeHandler.this.revertUpdateToRuntime(context, operation, attributeName, valueToRestore, resolvedValue, handback.handback);
                        }
                        catch (Exception e) {
                            ControllerLogger.MGMT_OP_LOGGER.errorRevertingOperation(e, this.getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress(operation.get("address")));
                        }
                        if (restartRequired) {
                            context.revertReloadRequired();
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected abstract boolean applyUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, HandbackHolder<T> var6) throws OperationFailedException;

    protected abstract void revertUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, T var6) throws OperationFailedException;

    protected void validateUnresolvedValue(String attributeName, ModelNode unresolvedValue) throws OperationFailedException {
        if (this.unresolvedValueValidator != null) {
            this.unresolvedValueValidator.validateParameter("value", unresolvedValue);
        }
    }

    protected void validateResolvedValue(String attributeName, ModelNode resolvedValue) throws OperationFailedException {
        if (this.resolvedValueValidator != null) {
            this.resolvedValueValidator.validateResolvedParameter("value", resolvedValue);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getType() == OperationContext.Type.SERVER && !context.isBooting();
    }

    protected AttributeDefinition getAttributeDefinition(String attributeName) {
        return this.attributeDefinitions == null ? null : this.attributeDefinitions.get(attributeName);
    }

    public static class HandbackHolder<T> {
        private T handback;

        public void setHandback(T handback) {
            this.handback = handback;
        }
    }
}

