/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.dmr.ModelNode;

public class ProxyStepHandler
implements OperationStepHandler {
    private final ProxyController proxyController;

    public ProxyStepHandler(ProxyController proxyController) {
        this.proxyController = proxyController;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) {
        DelegatingMessageHandler messageHandler = new DelegatingMessageHandler(context);
        final AtomicReference<ModelController.OperationTransaction> txRef = new AtomicReference<ModelController.OperationTransaction>();
        final AtomicReference<ModelNode> preparedResultRef = new AtomicReference<ModelNode>();
        final AtomicReference<ModelNode> finalResultRef = new AtomicReference<ModelNode>();
        ProxyController.ProxyOperationControl proxyControl = new ProxyController.ProxyOperationControl(){

            @Override
            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                txRef.set(transaction);
                preparedResultRef.set(result);
            }

            @Override
            public void operationFailed(ModelNode response) {
                finalResultRef.set(response);
            }

            @Override
            public void operationCompleted(ModelNode response) {
                finalResultRef.set(response);
            }
        };
        this.proxyController.execute(operation, messageHandler, proxyControl, new DelegatingOperationAttachments(context));
        ModelNode finalResult = (ModelNode)finalResultRef.get();
        if (finalResult != null) {
            context.getResult().set(finalResult.get("result"));
            context.getFailureDescription().set(finalResult.get("failure-description"));
            context.completeStep();
        } else {
            this.completeRemoteTransaction(context, operation, txRef, preparedResultRef, finalResultRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRemoteTransaction(OperationContext context, ModelNode operation, AtomicReference<ModelController.OperationTransaction> txRef, AtomicReference<ModelNode> preparedResultRef, AtomicReference<ModelNode> finalResultRef) {
        boolean txCompleted = false;
        try {
            ModelNode preparedResponse = preparedResultRef.get();
            ModelNode preparedResult = preparedResponse.get("result");
            if (preparedResponse.hasDefined("failure-description")) {
                context.getFailureDescription().set(preparedResponse.get("failure-description"));
                if (preparedResult.isDefined()) {
                    context.getResult().set(preparedResult);
                }
            } else {
                context.getResult().set(preparedResult);
            }
            OperationContext.ResultAction resultAction = context.completeStep();
            ModelController.OperationTransaction tx = txRef.get();
            try {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    tx.commit();
                } else {
                    tx.rollback();
                }
            }
            finally {
                txCompleted = true;
            }
            ModelNode finalResponse = finalResultRef.get();
            if (finalResponse != null) {
                ModelNode finalResult = finalResponse.get("result");
                if (finalResponse.hasDefined("failure-description")) {
                    context.getFailureDescription().set(finalResponse.get("failure-description"));
                    if (finalResult.isDefined()) {
                        context.getResult().set(finalResult);
                    }
                } else {
                    context.getResult().set(finalResult);
                }
            } else {
                ControllerLogger.SERVER_MANAGEMENT_LOGGER.noFinalProxyOutcomeReceived(operation.get("operation"), operation.get("address"), this.proxyController.getProxyNodeAddress().toModelNode());
            }
        }
        finally {
            if (!txCompleted && txRef.get() != null) {
                txRef.get().rollback();
            }
        }
    }

    private static class DelegatingOperationAttachments
    implements OperationAttachments {
        private final OperationContext context;

        private DelegatingOperationAttachments(OperationContext context) {
            this.context = context;
        }

        public boolean isAutoCloseStreams() {
            return false;
        }

        public List<InputStream> getInputStreams() {
            int count = this.context.getAttachmentStreamCount();
            ArrayList<InputStream> result = new ArrayList<InputStream>(count);
            for (int i = 0; i < count; ++i) {
                result.add(this.context.getAttachmentStream(i));
            }
            return result;
        }

        public void close() throws IOException {
        }
    }

    private static class DelegatingMessageHandler
    implements OperationMessageHandler {
        private final OperationContext context;

        DelegatingMessageHandler(OperationContext context) {
            this.context = context;
        }

        public void handleReport(MessageSeverity severity, String message) {
            this.context.report(severity, message);
        }
    }
}

