/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.remoting3.Channel;

public abstract class AbstractModelControllerOperationHandler<T, A>
extends AbstractMessageHandler<T, A> {
    public AbstractModelControllerOperationHandler(ExecutorService executorService) {
        super(executorService);
    }

    static /* synthetic */ ExecutorService access$000(AbstractModelControllerOperationHandler x0) {
        return x0.getExecutor();
    }

    private class ProxiedInputStream
    extends InputStream {
        final Channel channel;
        final int batchId;
        final int index;
        volatile byte[] bytes;
        volatile ByteArrayInputStream delegate;
        volatile Exception error;

        ProxiedInputStream(Channel channel, int batchId, int index) {
            this.channel = channel;
            this.batchId = batchId;
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            if (this.delegate == null) {
                ProxiedInputStream proxiedInputStream = this;
                synchronized (proxiedInputStream) {
                    if (this.delegate == null) {
                        this.initializeBytes();
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw ControllerMessages.MESSAGES.remoteCallerThreadInterrupted();
                        }
                        if (this.error != null) {
                            if (this.error instanceof IOException) {
                                throw (IOException)this.error;
                            }
                            throw new IOException(this.error);
                        }
                        this.delegate = new ByteArrayInputStream(this.bytes);
                        this.bytes = null;
                    }
                }
            }
            return this.delegate.read();
        }

        void initializeBytes() {
            if (this.bytes == null) {
                ActiveOperation support = AbstractModelControllerOperationHandler.this.getActiveOperation(this.batchId);
                AbstractModelControllerOperationHandler.this.executeRequest((ManagementRequest)new AbstractManagementRequest<T, A>(){

                    public byte getOperationType() {
                        return 76;
                    }

                    protected void sendRequest(ActiveOperation.ResultHandler<T> resultHandler, ManagementRequestContext<A> context, FlushableDataOutput output) throws IOException {
                        output.write(102);
                        output.writeInt(ProxiedInputStream.this.index);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleRequest(DataInput input, ActiveOperation.ResultHandler<T> resultHandler, ManagementRequestContext<A> context) throws IOException {
                        ProxiedInputStream proxiedInputStream = ProxiedInputStream.this;
                        synchronized (proxiedInputStream) {
                            ProtocolUtils.expectHeader((DataInput)input, (int)103);
                            int size = input.readInt();
                            ProtocolUtils.expectHeader((DataInput)input, (int)104);
                            byte[] buf = new byte[size];
                            for (int i = 0; i < size; ++i) {
                                buf[i] = input.readByte();
                            }
                            ProxiedInputStream.this.bytes = buf;
                            ProxiedInputStream.this.notifyAll();
                        }
                    }
                }, this.channel, support);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown(Exception error) {
            this.error = error;
            ProxiedInputStream proxiedInputStream = this;
            synchronized (proxiedInputStream) {
                this.notifyAll();
            }
        }
    }

    class OperationAttachmentsProxy
    implements OperationAttachments {
        final List<ProxiedInputStream> proxiedStreams;

        OperationAttachmentsProxy(Channel channel, int batchId, int size) {
            this.proxiedStreams = new ArrayList<ProxiedInputStream>(size);
            for (int i = 0; i < size; ++i) {
                this.proxiedStreams.add(new ProxiedInputStream(channel, batchId, i));
            }
        }

        public boolean isAutoCloseStreams() {
            return false;
        }

        public List<InputStream> getInputStreams() {
            ArrayList<ProxiedInputStream> result = new ArrayList<ProxiedInputStream>();
            result.addAll(this.proxiedStreams);
            return Collections.unmodifiableList(result);
        }

        public void close() throws IOException {
        }

        void shutdown(Exception error) {
            for (ProxiedInputStream stream : this.proxiedStreams) {
                stream.shutdown(error);
            }
        }
    }

    class OperationMessageHandlerProxy
    implements OperationMessageHandler {
        final Channel channel;
        final int batchId;

        public OperationMessageHandlerProxy(Channel channel, int batchId) {
            this.channel = channel;
            this.batchId = batchId;
        }

        public void handleReport(MessageSeverity severity, String message) {
        }
    }
}

