/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.beanvalidation;

import javax.validation.ValidatorFactory;
import org.jboss.as.ee.beanvalidation.BeanValidationAttachments;
import org.jboss.as.ee.beanvalidation.LazyValidatorFactory;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class BeanValidationFactoryDeployer
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (module == null || moduleDescription == null) {
            return;
        }
        LazyValidatorFactory factory = new LazyValidatorFactory((ClassLoader)module.getClassLoader());
        deploymentUnit.putAttachment(BeanValidationAttachments.VALIDATOR_FACTORY, (Object)factory);
        this.bindFactoryToJndi(factory, deploymentUnit, phaseContext, moduleDescription);
    }

    private void bindFactoryToJndi(LazyValidatorFactory factory, DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, EEModuleDescription moduleDescription) {
        if (moduleDescription == null) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        if (DeploymentTypeMarker.isType(DeploymentType.WAR, deploymentUnit) || DeploymentTypeMarker.isType(DeploymentType.APPLICATION_CLIENT, deploymentUnit)) {
            ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
            this.bindServices(factory, serviceTarget, moduleDescription, moduleDescription.getModuleName(), moduleContextServiceName);
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (component.getNamingMode() != ComponentNamingMode.CREATE) continue;
            ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName(), (String)component.getComponentName());
            this.bindServices(factory, serviceTarget, moduleDescription, component.getComponentName(), compContextServiceName);
        }
    }

    private void bindServices(LazyValidatorFactory factory, ServiceTarget serviceTarget, EEModuleDescription description, String componentName, ServiceName contextServiceName) {
        BinderService validatorFactoryBindingService = new BinderService("ValidatorFactory");
        validatorFactoryBindingService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue((Object)factory)));
        serviceTarget.addService(contextServiceName.append(new String[]{"ValidatorFactory"}), (Service)validatorFactoryBindingService).addDependency(contextServiceName, ServiceBasedNamingStore.class, validatorFactoryBindingService.getNamingStoreInjector()).install();
        BinderService validatorBindingService = new BinderService("Validator");
        validatorBindingService.getManagedObjectInjector().inject((Object)new ValidatorJndiInjectable(factory));
        serviceTarget.addService(contextServiceName.append(new String[]{"Validator"}), (Service)validatorBindingService).addDependency(contextServiceName, ServiceBasedNamingStore.class, validatorBindingService.getNamingStoreInjector()).install();
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static final class ValidatorJndiInjectable
    implements ManagedReferenceFactory {
        private final ValidatorFactory factory;

        public ValidatorJndiInjectable(ValidatorFactory factory) {
            this.factory = factory;
        }

        public ManagedReference getReference() {
            return new ValueManagedReference((Value)new ImmediateValue((Object)this.factory.getValidator()));
        }
    }
}

