/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

class ManagedReferenceInterceptorFactory
implements InterceptorFactory {
    private final ManagedReferenceFactory componentInstantiation;
    private final Object contextKey;

    public ManagedReferenceInterceptorFactory(ManagedReferenceFactory componentInstantiation, Object contextKey) {
        if (componentInstantiation == null) {
            throw EeMessages.MESSAGES.nullVar("componentInstantiation");
        }
        if (contextKey == null) {
            throw EeMessages.MESSAGES.nullVar("contextKey");
        }
        this.componentInstantiation = componentInstantiation;
        this.contextKey = contextKey;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        AtomicReference<ManagedReference> referenceReference = new AtomicReference<ManagedReference>();
        context.getContextData().put(this.contextKey, referenceReference);
        return new ManagedReferenceInterceptor(this.componentInstantiation, referenceReference);
    }

    static final class ManagedReferenceInterceptor
    implements Interceptor {
        private final ManagedReferenceFactory componentInstantiator;
        private final AtomicReference<ManagedReference> referenceReference;

        public ManagedReferenceInterceptor(ManagedReferenceFactory componentInstantiator, AtomicReference<ManagedReference> referenceReference) {
            this.componentInstantiator = componentInstantiator;
            this.referenceReference = referenceReference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processInvocation(InterceptorContext context) throws Exception {
            ManagedReference existing = this.referenceReference.get();
            if (existing == null) {
                ManagedReference reference = this.componentInstantiator.getReference();
                boolean ok = false;
                try {
                    this.referenceReference.set(reference);
                    context.setTarget(reference.getInstance());
                    Object result = context.proceed();
                    ok = true;
                    Object object = result;
                    return object;
                }
                finally {
                    context.setTarget(null);
                    if (!ok) {
                        reference.release();
                        this.referenceReference.set(null);
                    }
                }
            }
            return context.proceed();
        }
    }
}

