/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.openjpa;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class JBossPersistenceMetaDataFactory
extends PersistenceMetaDataFactory {
    private static ThreadLocal<PersistenceUnitMetadata> persistenceUnitMetadata = new ThreadLocal();

    protected Set<String> parsePersistentTypeNames(ClassLoader loader) {
        PersistenceUnitMetadata pu = persistenceUnitMetadata.get();
        if (pu == null) {
            return Collections.emptySet();
        }
        return this.findPersistenceTypeNames(pu);
    }

    static void setThreadLocalPersistenceUnitMetadata(PersistenceUnitMetadata pu) {
        persistenceUnitMetadata.set(pu);
    }

    static void clearThreadLocalPersistenceUnitMetadata() {
        persistenceUnitMetadata.remove();
    }

    private Set<String> findPersistenceTypeNames(PersistenceUnitMetadata pu) {
        HashSet<String> persistenceTypeNames = new HashSet<String>();
        for (Map.Entry entry : pu.getAnnotationIndex().entrySet()) {
            List instances = ((Index)entry.getValue()).getAnnotations(DotName.createSimple((String)Entity.class.getName()));
            for (AnnotationInstance instance : instances) {
                AnnotationTarget target = instance.target();
                if (!(target instanceof ClassInfo)) continue;
                ClassInfo classInfo = (ClassInfo)target;
                persistenceTypeNames.add(classInfo.name().toString());
            }
        }
        return persistenceTypeNames;
    }
}

