/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.List;
import java.util.Locale;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSQueueService;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.JndiEntriesAttribute;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class JMSQueueAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final JMSQueueAdd INSTANCE = new JMSQueueAdd();

    public static ModelNode getOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        if (existing.hasDefined(CommonAttributes.SELECTOR.getName())) {
            op.get(CommonAttributes.SELECTOR.getName()).set(existing.get(CommonAttributes.SELECTOR.getName()));
        }
        if (existing.hasDefined(CommonAttributes.DURABLE.getName())) {
            op.get(CommonAttributes.DURABLE.getName()).set(existing.get(CommonAttributes.DURABLE.getName()));
        }
        if (existing.hasDefined(CommonAttributes.ENTRIES.getName())) {
            op.get(CommonAttributes.ENTRIES.getName()).set(existing.get(CommonAttributes.ENTRIES.getName()));
        }
        return op;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : CommonAttributes.JMS_QUEUE_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ModelNode selectorNode = CommonAttributes.SELECTOR.resolveModelAttribute(context, model);
        String selector = selectorNode.isDefined() ? selectorNode.asString() : null;
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        JMSQueueService service = new JMSQueueService(name, selector, CommonAttributes.DURABLE.resolveModelAttribute(context, model).asBoolean(), JndiEntriesAttribute.getJndiBindings(operation));
        ServiceName serviceName = JMSServices.getJmsQueueBaseServiceName(hqServiceName).append(new String[]{name});
        newControllers.add(context.getServiceTarget().addService(serviceName, (Service)service).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName), JMSServerManager.class, service.getJmsServer()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getJmsQueueAdd(locale);
    }
}

