/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.shell.ShellService;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;

public class ShellServlet
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    private static final String LABEL = "shell";
    private static final String TITLE = "%shell.pluginTitle";
    private static final String[] CSS = new String[]{"/res/ui/shell.css"};
    private final String TEMPLATE = this.readTemplateFile("/templates/shell.html");
    static /* synthetic */ Class class$org$apache$felix$shell$ShellService;

    public ShellServlet() {
        super(LABEL, TITLE, CSS);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
        PrintWriter pw = response.getWriter();
        try {
            String command = request.getParameter("command");
            if (command != null) {
                command = WebConsoleUtil.urlDecode(command);
            }
            pw.print("<span class=\"consolecommand\">-&gt; ");
            pw.print(command == null ? "" : WebConsoleUtil.escapeHtml(command));
            pw.println("</span><br />");
            if (command != null && command.length() > 0) {
                ShellService shellService = this.getShellService();
                if (shellService != null) {
                    ByteArrayOutputStream baosOut = new ByteArrayOutputStream();
                    ByteArrayOutputStream baosErr = new ByteArrayOutputStream();
                    shellService.executeCommand(command, new PrintStream(baosOut, true), new PrintStream(baosErr, true));
                    if (baosOut.size() > 0) {
                        pw.print(WebConsoleUtil.escapeHtml(new String(baosOut.toByteArray())));
                    }
                    if (baosErr.size() > 0) {
                        pw.print("<span class=\"error\">");
                        pw.print(WebConsoleUtil.escapeHtml(new String(baosErr.toByteArray())));
                        pw.println("</span>");
                    }
                } else {
                    pw.print("<span class=\"error\">");
                    pw.print("Error: No shell service available<br />");
                    pw.println("</span>");
                }
            }
        }
        catch (Throwable t) {
            pw.print("<span class=\"error\">");
            StringWriter out = new StringWriter();
            t.printStackTrace(new PrintWriter((Writer)out, true));
            pw.print(WebConsoleUtil.escapeHtml(out.toString()));
            pw.println("</span>");
        }
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        DefaultVariableResolver vr = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        if (this.getShellService() == null) {
            vr.put("shell.status", "Shell Service not available");
            vr.put("shell.disabled", "true");
        } else {
            vr.put("shell.disabled", "false");
        }
        response.getWriter().print(this.TEMPLATE);
    }

    private final ShellService getShellService() {
        try {
            return (ShellService)this.getService((class$org$apache$felix$shell$ShellService == null ? (class$org$apache$felix$shell$ShellService = ShellServlet.class$("org.apache.felix.shell.ShellService")) : class$org$apache$felix$shell$ShellService).getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

