/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class DelayedComponentManager
extends ImmediateComponentManager
implements ServiceFactory {
    private final Object m_useCountLock = new Object();
    private int m_useCount = 0;

    public DelayedComponentManager(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata) {
        super(activator, componentHolder, metadata);
    }

    protected boolean createComponent() {
        return true;
    }

    protected void deleteComponent(int reason) {
        if (this.getInstance() != null) {
            super.deleteComponent(reason);
        }
        this.m_useCount = 0;
    }

    protected Object getService() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getService(Bundle bundle, ServiceRegistration sr) {
        Object object = this.m_useCountLock;
        synchronized (object) {
            ++this.m_useCount;
            return this.state().getService(this);
        }
    }

    protected boolean createRealComponent() {
        return super.createComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle bundle, ServiceRegistration sr, Object service) {
        Object object = this.m_useCountLock;
        synchronized (object) {
            if (this.m_useCount > 0) {
                --this.m_useCount;
                if (this.m_useCount == 0) {
                    this.state().ungetService(this);
                }
            }
        }
    }
}

