/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitPhaseService;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractDeploymentUnitService
implements Service<DeploymentUnit> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment");
    private static final String FIRST_PHASE_NAME = Phase.values()[0].name();
    private final InjectedValue<DeployerChains> deployerChainsInjector = new InjectedValue();
    private DeploymentUnit deploymentUnit;
    private volatile DeploymentServiceListener listener;

    protected AbstractDeploymentUnitService() {
    }

    public synchronized void start(StartContext context) throws StartException {
        DeploymentServiceListener listener;
        ServiceTarget target = context.getChildTarget();
        String deploymentName = context.getController().getName().getSimpleName();
        this.listener = listener = new DeploymentServiceListener(deploymentName);
        log.infof("Starting deployment of \"%s\"", (Object)deploymentName);
        target.addListener(ServiceListener.Inheritance.ALL, (ServiceListener)listener);
        this.deploymentUnit = this.createAndInitializeDeploymentUnit((ServiceRegistry)context.getController().getServiceContainer());
        this.deploymentUnit.putAttachment(Attachments.STATUS_LISTENER, listener);
        ServiceName serviceName = this.deploymentUnit.getServiceName().append(new String[]{FIRST_PHASE_NAME});
        Phase firstPhase = Phase.values()[0];
        DeploymentUnitPhaseService<?> phaseService = DeploymentUnitPhaseService.create(this.deploymentUnit, firstPhase);
        ServiceBuilder phaseServiceBuilder = target.addService(serviceName, phaseService);
        phaseServiceBuilder.addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, phaseService.getDeployerChainsInjector());
        phaseServiceBuilder.install();
    }

    protected abstract DeploymentUnit createAndInitializeDeploymentUnit(ServiceRegistry var1);

    public synchronized void stop(StopContext context) {
        String deploymentName = context.getController().getName().getSimpleName();
        this.deploymentUnit = null;
        log.infof("Stopped deployment %s in %dms", (Object)deploymentName, (Object)((int)(context.getElapsedTime() / 1000000L)));
    }

    public synchronized DeploymentUnit getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentUnit;
    }

    public void reportStatus() {
        this.listener.explainStatus();
    }

    public DeploymentStatus getStatus() {
        return this.listener.getStatus();
    }

    Injector<DeployerChains> getDeployerChainsInjector() {
        return this.deployerChainsInjector;
    }

    public static final class DeploymentServiceListener
    extends AbstractServiceListener<Object> {
        private final String deploymentName;
        private final Set<ServiceController<?>> startFailedServices = Collections.newSetFromMap(new IdentityHashMap());
        private final Set<ServiceController<?>> servicesMissingDependencies = Collections.newSetFromMap(new IdentityHashMap());
        private DeploymentStatus previous = DeploymentStatus.NEW;

        public DeploymentServiceListener(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        public synchronized DeploymentStatus getStatus() {
            return this.startFailedServices.isEmpty() && this.servicesMissingDependencies.isEmpty() ? DeploymentStatus.OK : DeploymentStatus.FAILED;
        }

        public synchronized void explainStatus() {
            DeploymentStatus newStatus;
            DeploymentStatus oldStatus = this.previous;
            boolean hasFailed = !this.startFailedServices.isEmpty();
            boolean hasMissing = !this.servicesMissingDependencies.isEmpty();
            DeploymentStatus deploymentStatus = newStatus = hasFailed || hasMissing ? DeploymentStatus.FAILED : DeploymentStatus.OK;
            if (oldStatus != newStatus) {
                this.previous = newStatus;
                if (hasFailed || hasMissing) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Deployment '").append(this.deploymentName).append("' has ");
                    if (hasFailed) {
                        msg.append("failed services");
                        if (hasMissing) {
                            msg.append(" and ");
                        }
                    }
                    if (hasMissing) {
                        msg.append("services missing dependencies");
                    }
                    if (hasFailed) {
                        msg.append("\n    Failed services:");
                        for (ServiceController<?> service : this.startFailedServices) {
                            StartException cause = service.getStartException();
                            if (cause == null) continue;
                            msg.append("\n        ").append(service.getName()).append(": ").append(cause);
                        }
                    }
                    if (hasMissing) {
                        msg.append("\n    Missing dependencies:");
                        for (ServiceController<?> service : this.servicesMissingDependencies) {
                            msg.append("\n        ").append(service.getName()).append(" is missing: ");
                            for (ServiceName name : service.getImmediateUnavailableDependencies()) {
                                msg.append("\n            ").append(name);
                            }
                        }
                    }
                    log.error((Object)msg);
                } else {
                    log.infof("Deployment '%s' started successfully", (Object)this.deploymentName);
                }
            }
        }

        public synchronized void immediateDependencyAvailable(ServiceController<? extends Object> controller) {
            this.servicesMissingDependencies.remove(controller);
        }

        public synchronized void immediateDependencyUnavailable(ServiceController<? extends Object> controller) {
            this.servicesMissingDependencies.add(controller);
        }

        public synchronized void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
            switch (transition) {
                case REMOVING_to_REMOVED: {
                    this.servicesMissingDependencies.remove(controller);
                }
                case START_FAILED_to_DOWN: 
                case START_FAILED_to_STARTING: {
                    this.startFailedServices.remove(controller);
                    break;
                }
                case STARTING_to_START_FAILED: {
                    this.startFailedServices.add(controller);
                }
            }
        }
    }

    public static enum DeploymentStatus {
        NEW,
        OK,
        FAILED,
        STOPPED;

    }
}

