/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.deployment.AbstractDeploymentHandler;
import org.jboss.as.server.deployment.ContentServitor;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.PathContentServitor;
import org.jboss.as.server.deployment.RootDeploymentUnitService;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.repository.api.ServerDeploymentRepository;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.VirtualFile;

public class DeploymentHandlerUtil {
    private static final ServerLogger log = ServerLogger.DEPLOYMENT_LOGGER;

    private DeploymentHandlerUtil() {
    }

    public static void deploy(OperationContext context, final String deploymentUnitName, final String managementName, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (context.getType() == OperationContext.Type.SERVER) {
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
            DeploymentModelUtils.cleanup(deployment);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
                    ServiceController deploymentController = serviceRegistry.getService(deploymentUnitServiceName);
                    if (deploymentController != null) {
                        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                        deploymentController.addListener((ServiceListener)verificationHandler);
                        deploymentController.setMode(ServiceController.Mode.ACTIVE);
                        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                            deploymentController.setMode(ServiceController.Mode.NEVER);
                        }
                    } else {
                        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                        Collection controllers = DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, verificationHandler, deployment, registration, mutableRegistration, contents);
                        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                            for (ServiceController controller : controllers) {
                                context.removeService(controller.getName());
                            }
                            if (context.hasFailureDescription()) {
                                ServerLogger.ROOT_LOGGER.undeploymentRolledBack(deploymentUnitName, context.getFailureDescription().asString());
                            } else {
                                ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(deploymentUnitName);
                            }
                        } else {
                            ServerLogger.ROOT_LOGGER.deploymentDeployed(deploymentUnitName);
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static Collection<ServiceController<?>> doDeploy(OperationContext context, String deploymentUnitName, String managementName, ServiceVerificationHandler verificationHandler, Resource deploymentResource, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, ContentItem ... contents) {
        ServiceController<VirtualFile> contentService;
        ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
        ArrayList controllers = new ArrayList();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName contentsServiceName = deploymentUnitServiceName.append(new String[]{"contents"});
        if (contents[0].hash != null) {
            contentService = ContentServitor.addService(serviceTarget, contentsServiceName, contents[0].hash, verificationHandler);
        } else {
            String path = contents[0].path;
            String relativeTo = contents[0].relativeTo;
            ServiceName relativeToPathServiceName = relativeTo != null ? RelativePathService.pathNameOf(relativeTo) : null;
            contentService = PathContentServitor.addService(serviceTarget, contentsServiceName, path, relativeToPathServiceName, verificationHandler);
        }
        controllers.add(contentService);
        RootDeploymentUnitService service = new RootDeploymentUnitService(deploymentUnitName, managementName, null, registration, mutableRegistration, deploymentResource, verificationHandler);
        final ServiceController deploymentUnitController = serviceTarget.addService(deploymentUnitServiceName, (Service)service).addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, service.getDeployerChainsInjector()).addDependency(ServerDeploymentRepository.SERVICE_NAME, ServerDeploymentRepository.class, service.getServerDeploymentRepositoryInjector()).addDependency(contentsServiceName, VirtualFile.class, service.contentsInjector).addListener(ServiceListener.Inheritance.ALL, (ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
        controllers.add(deploymentUnitController);
        contentService.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                if (transition == ServiceController.Transition.REMOVING_to_REMOVED) {
                    deploymentUnitController.setMode(ServiceController.Mode.REMOVE);
                }
            }
        });
        return controllers;
    }

    public static void redeploy(OperationContext operationContext, final String deploymentUnitName, final String managementName, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (operationContext.getType() == OperationContext.Type.SERVER) {
            final Resource deployment = operationContext.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ImmutableManagementResourceRegistration registration = operationContext.getResourceRegistration();
            final ManagementResourceRegistration mutableRegistration = operationContext.getResourceRegistrationForUpdate();
            DeploymentModelUtils.cleanup(deployment);
            operationContext.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    context.removeService(deploymentUnitServiceName);
                    context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                    context.addStep(new OperationStepHandler(){

                        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                            ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                            DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, verificationHandler, deployment, registration, mutableRegistration, contents);
                            if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                                if (context.hasFailureDescription()) {
                                    ServerLogger.ROOT_LOGGER.redeployRolledBack(deploymentUnitName, context.getFailureDescription().asString());
                                } else {
                                    ServerLogger.ROOT_LOGGER.redeployRolledBackWithNoMessage(deploymentUnitName);
                                }
                            } else {
                                ServerLogger.ROOT_LOGGER.deploymentRedeployed(deploymentUnitName);
                            }
                        }
                    }, OperationContext.Stage.IMMEDIATE);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        if (context.hasFailureDescription()) {
                            ServerLogger.ROOT_LOGGER.undeploymentRolledBack(deploymentUnitName, context.getFailureDescription().asString());
                        } else {
                            ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(deploymentUnitName);
                        }
                    } else {
                        ServerLogger.ROOT_LOGGER.deploymentUndeployed(deploymentUnitName);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        operationContext.completeStep();
    }

    public static void replace(final OperationContext operationContext, final ModelNode originalDeployment, final String deploymentUnitName, final String managementName, final String replacedDeploymentUnitName, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (operationContext.getType() == OperationContext.Type.SERVER) {
            PathElement path = PathElement.pathElement((String)"deployment", (String)managementName);
            final Resource deployment = operationContext.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            final ImmutableManagementResourceRegistration registration = operationContext.getResourceRegistration().getSubModel(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            final ManagementResourceRegistration mutableRegistration = operationContext.getResourceRegistrationForUpdate().getSubModel(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            DeploymentModelUtils.cleanup(deployment);
            operationContext.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName replacedDeploymentUnitServiceName = Services.deploymentUnitName(replacedDeploymentUnitName);
                    ServiceName replacedContentsServiceName = replacedDeploymentUnitServiceName.append(new String[]{"contents"});
                    operationContext.removeService(replacedContentsServiceName);
                    operationContext.removeService(replacedDeploymentUnitServiceName);
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    Collection controllers = DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, verificationHandler, deployment, registration, mutableRegistration, contents);
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        for (ServiceController controller : controllers) {
                            context.removeService(controller.getName());
                        }
                        DeploymentModelUtils.cleanup(deployment);
                        String name = originalDeployment.require("name").asString();
                        String runtimeName = originalDeployment.require("runtime-name").asString();
                        ContentItem[] contents2 = AbstractDeploymentHandler.getContents(originalDeployment.require("content"));
                        verificationHandler = new ServiceVerificationHandler();
                        DeploymentHandlerUtil.doDeploy(context, runtimeName, name, verificationHandler, deployment, registration, mutableRegistration, contents2);
                        if (context.hasFailureDescription()) {
                            ServerLogger.ROOT_LOGGER.replaceRolledBack(replacedDeploymentUnitName, deploymentUnitName, context.getFailureDescription().asString());
                        } else {
                            ServerLogger.ROOT_LOGGER.replaceRolledBackWithNoMessage(replacedDeploymentUnitName, deploymentUnitName);
                        }
                    } else {
                        ServerLogger.ROOT_LOGGER.deploymentReplaced(replacedDeploymentUnitName, deploymentUnitName);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public static void undeploy(OperationContext context, final String deploymentUnitName) {
        if (context.getType() == OperationContext.Type.SERVER) {
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
            DeploymentModelUtils.cleanup(deployment);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    context.removeService(deploymentUnitServiceName);
                    context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
                        String name = model.require("name").asString();
                        String runtimeName = model.require("runtime-name").asString();
                        ContentItem[] contents = AbstractDeploymentHandler.getContents(model.require("content"));
                        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                        DeploymentHandlerUtil.doDeploy(context, runtimeName, name, verificationHandler, deployment, registration, mutableRegistration, contents);
                        if (context.hasFailureDescription()) {
                            ServerLogger.ROOT_LOGGER.undeploymentRolledBack(deploymentUnitName, context.getFailureDescription().asString());
                        } else {
                            ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(deploymentUnitName);
                        }
                    } else {
                        ServerLogger.ROOT_LOGGER.deploymentUndeployed(deploymentUnitName);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    static class ContentItem {
        private byte[] hash;
        private String path;
        private String relativeTo;
        private boolean isArchive;

        ContentItem(byte[] hash) {
            assert (hash != null) : "hash is null";
            this.hash = hash;
        }

        ContentItem(String path, String relativeTo, boolean isArchive) {
            assert (path != null) : "path is null";
            this.path = path;
            this.relativeTo = relativeTo;
            this.isArchive = isArchive;
        }
    }
}

