/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.PathAddHandler;
import org.jboss.as.server.services.path.AbsolutePathService;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class SpecifiedPathAddHandler
extends PathAddHandler {
    public static SpecifiedPathAddHandler INSTANCE = new SpecifiedPathAddHandler();

    private SpecifiedPathAddHandler() {
        super(true);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ModelNode pathNode = operation.get("path");
        ModelNode relNode = operation.get("relative-to");
        String path = pathNode.isDefined() ? pathNode.asString() : null;
        String relativeTo = relNode.isDefined() ? relNode.asString() : null;
        ServiceTarget target = context.getServiceTarget();
        if (relativeTo == null) {
            newControllers.add(AbsolutePathService.addService(name, path, target, newControllers, new ServiceListener[]{verificationHandler}));
        } else {
            newControllers.add(RelativePathService.addService(name, path, relativeTo, target, newControllers, new ServiceListener[]{verificationHandler}));
        }
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

