/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.SocketBindingAddHandler;
import org.jboss.as.controller.resource.AbstractSocketBindingResourceDefinition;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.net.SocketBindingService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class BindingAddHandler
extends SocketBindingAddHandler {
    public static final BindingAddHandler INSTANCE = new BindingAddHandler();

    private BindingAddHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        try {
            newControllers.add(BindingAddHandler.installBindingService(context, model, name));
        }
        catch (UnknownHostException e) {
            throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    public static ServiceController<SocketBinding> installBindingService(OperationContext context, ModelNode config, String name) throws UnknownHostException, OperationFailedException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode intfNode = AbstractSocketBindingResourceDefinition.INTERFACE.resolveModelAttribute(context, config);
        String intf = intfNode.isDefined() ? intfNode.asString() : null;
        int port = AbstractSocketBindingResourceDefinition.PORT.resolveModelAttribute(context, config).asInt();
        boolean fixedPort = AbstractSocketBindingResourceDefinition.FIXED_PORT.resolveModelAttribute(context, config).asBoolean();
        ModelNode mcastNode = AbstractSocketBindingResourceDefinition.MULTICAST_ADDRESS.resolveModelAttribute(context, config);
        String mcastAddr = mcastNode.isDefined() ? mcastNode.asString() : null;
        int mcastPort = AbstractSocketBindingResourceDefinition.MULTICAST_PORT.resolveModelAttribute(context, config).asInt(0);
        InetAddress mcastInet = mcastAddr == null ? null : InetAddress.getByName(mcastAddr);
        SocketBindingService service = new SocketBindingService(name, port, fixedPort, mcastInet, mcastPort);
        ServiceBuilder builder = serviceTarget.addService(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{name}), (Service)service);
        if (intf != null) {
            builder.addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{intf}), NetworkInterfaceBinding.class, service.getInterfaceBinding());
        }
        return builder.addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, service.getSocketBindings()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }
}

