/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class CommonPoolImpl
implements CommonPool {
    private static final long serialVersionUID = -8705723067326455982L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    protected final Integer minPoolSize;
    protected final Integer maxPoolSize;
    protected final Boolean prefill;
    protected final Boolean useStrictMin;
    protected final FlushStrategy flushStrategy;

    public CommonPoolImpl(Integer minPoolSize, Integer maxPoolSize, Boolean prefill, Boolean useStrictMin, FlushStrategy flushStrategy) throws ValidateException {
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.prefill = prefill;
        this.useStrictMin = useStrictMin;
        this.flushStrategy = flushStrategy;
        this.validate();
    }

    public final Integer getMinPoolSize() {
        return this.minPoolSize;
    }

    public final Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public final Boolean isPrefill() {
        return this.prefill;
    }

    public final Boolean isUseStrictMin() {
        return this.useStrictMin;
    }

    public final FlushStrategy getFlushStrategy() {
        return this.flushStrategy;
    }

    public void validate() throws ValidateException {
        if (this.maxPoolSize != null && this.maxPoolSize < 0) {
            throw new ValidateException(bundle.invalidNegative(CommonPool.Tag.MAX_POOL_SIZE.getLocalName()));
        }
        if (this.minPoolSize != null && this.minPoolSize < 0) {
            throw new ValidateException(bundle.invalidNegative(CommonPool.Tag.MIN_POOL_SIZE.getLocalName()));
        }
        if (this.flushStrategy == null) {
            throw new ValidateException(bundle.nullValue(CommonPool.Tag.FLUSH_STRATEGY.getLocalName()));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<pool>");
        if (this.minPoolSize != null) {
            sb.append("<").append(CommonPool.Tag.MIN_POOL_SIZE).append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append(CommonPool.Tag.MIN_POOL_SIZE).append(">");
        }
        if (this.maxPoolSize != null) {
            sb.append("<").append(CommonPool.Tag.MAX_POOL_SIZE).append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append(CommonPool.Tag.MAX_POOL_SIZE).append(">");
        }
        if (this.prefill != null) {
            sb.append("<").append(CommonPool.Tag.PREFILL).append(">");
            sb.append(this.prefill);
            sb.append("</").append(CommonPool.Tag.PREFILL).append(">");
        }
        if (this.useStrictMin != null) {
            sb.append("<").append(CommonPool.Tag.USE_STRICT_MIN).append(">");
            sb.append(this.useStrictMin);
            sb.append("</").append(CommonPool.Tag.USE_STRICT_MIN).append(">");
        }
        if (this.flushStrategy != null) {
            sb.append("<").append(CommonPool.Tag.FLUSH_STRATEGY).append(">");
            sb.append(this.flushStrategy);
            sb.append("</").append(CommonPool.Tag.FLUSH_STRATEGY).append(">");
        }
        sb.append("</pool>");
        return sb.toString();
    }
}

