/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static String getSystemProperty(final String property) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(property);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(property);
            }
        });
    }

    static void setSystemProperty(final String property, final String value) {
        if (System.getSecurityManager() == null) {
            System.setProperty(property, value);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty(property, value);
                    return null;
                }
            });
        }
    }
}

