/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.host.controller.Element;
import org.jboss.as.host.controller.HostControllerMessages;

public final class PropertiesElement {
    private static final long serialVersionUID = 1614693052895734582L;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Element propertyType;
    private final boolean allowNullValue;

    public PropertiesElement(Element propertyType, boolean allowNullValue) {
        this.propertyType = propertyType;
        this.allowNullValue = allowNullValue;
    }

    public PropertiesElement(Element propertyType, boolean allowNullValue, PropertiesElement ... toCombine) {
        this.allowNullValue = allowNullValue;
        this.propertyType = propertyType;
        if (toCombine != null) {
            for (PropertiesElement pe : toCombine) {
                if (pe == null) continue;
                for (String name : pe.getPropertyNames()) {
                    String val = pe.getProperty(name);
                    if (!allowNullValue && val == null) {
                        throw HostControllerMessages.MESSAGES.propertyValueHasNullValue(name);
                    }
                    this.properties.put(name, val);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long elementHash() {
        long total = 0L;
        Map<String, String> map = this.properties;
        synchronized (map) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String val = entry.getValue();
                int valHash = val == null ? 0 : val.hashCode();
                total = Long.rotateLeft(total, 1) ^ ((long)entry.getKey().hashCode() << 32 | (long)valHash & 0xFFFFFFFFL);
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProperty(String name, String value) {
        Map<String, String> map = this.properties;
        synchronized (map) {
            if (this.properties.containsKey(name)) {
                throw HostControllerMessages.MESSAGES.propertyAlreadyExists(name);
            }
            if (value == null && !this.allowNullValue) {
                throw HostControllerMessages.MESSAGES.propertyValueNull(name);
            }
            this.properties.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String removeProperty(String name) {
        Map<String, String> map = this.properties;
        synchronized (map) {
            String old = this.properties.remove(name);
            if (old == null) {
                throw HostControllerMessages.MESSAGES.propertyNotFound(name);
            }
            return old;
        }
    }

    public int size() {
        return this.properties.size();
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<String> getPropertyNames() {
        return new HashSet<String>(this.properties.keySet());
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }
}

