/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelReceiver;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.MessageOutputStream;

public class ServerToHostOperationHandlerFactoryService
implements ManagementChannelInitialization,
Service<ManagementChannelInitialization> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"management", "server", "to", "host", "controller"});
    private final ExecutorService executorService;
    private final InjectedValue<ServerInventory> callback = new InjectedValue();

    private ServerToHostOperationHandlerFactoryService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public static void install(ServiceTarget serviceTarget, ServiceName serverInventoryName, ExecutorService executorService) {
        ServerToHostOperationHandlerFactoryService serverToHost = new ServerToHostOperationHandlerFactoryService(executorService);
        serviceTarget.addService(SERVICE_NAME, (Service)serverToHost).addDependency(serverInventoryName, ServerInventory.class, serverToHost.callback).install();
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public ManagementChannelInitialization getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public HandleableCloseable.Key startReceiving(Channel channel) {
        InitialMessageHandler receiver = new InitialMessageHandler(this.executorService);
        channel.receiveMessage((Channel.Receiver)receiver);
        return null;
    }

    protected static void safeWriteResponse(Channel channel, ManagementProtocolHeader header, Exception error) {
        if (header.getType() == 2) {
            try {
                ServerToHostOperationHandlerFactoryService.writeResponse(channel, (ManagementRequestHeader)header, error);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeResponse(Channel channel, ManagementRequestHeader header, Exception error) throws IOException {
        ManagementResponseHeader response = ManagementResponseHeader.create((ManagementRequestHeader)header, (Exception)error);
        MessageOutputStream output = channel.writeMessage();
        try {
            ServerToHostOperationHandlerFactoryService.writeHeader((ManagementProtocolHeader)response, (OutputStream)output);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    protected static void writeHeader(ManagementProtocolHeader header, OutputStream os) throws IOException {
        FlushableDataOutput output = org.jboss.as.protocol.mgmt.ProtocolUtils.wrapAsDataOutput((OutputStream)os);
        header.write((DataOutput)output);
        output.flush();
    }

    private class InitialMessageHandler
    extends ManagementChannelReceiver {
        private final ExecutorService executorService;

        private InitialMessageHandler(ExecutorService executorService) {
            this.executorService = executorService;
        }

        public void handleMessage(Channel channel, DataInput input, ManagementProtocolHeader header) throws IOException {
            byte type = header.getType();
            if (type == 2) {
                ManagementRequestHeader request = (ManagementRequestHeader)header;
                this.handleMessage(channel, input, request);
            } else {
                ServerToHostOperationHandlerFactoryService.safeWriteResponse(channel, header, HostControllerMessages.MESSAGES.unrecognizedType(type));
                channel.close();
            }
        }

        public void handleMessage(final Channel channel, DataInput input, final ManagementRequestHeader header) throws IOException {
            byte type = header.getOperationId();
            if (type == 0) {
                ProtocolUtils.expectHeader((DataInput)input, (int)1);
                final String serverName = input.readUTF();
                HostControllerLogger.CONTROLLER_MANAGEMENT_LOGGER.serverRegistered(serverName, channel);
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        final Channel mgmtChannel = channel;
                        ((ServerInventory)ServerToHostOperationHandlerFactoryService.this.callback.getValue()).serverRegistered(serverName, mgmtChannel, new ServerInventory.ProxyCreatedCallback(){

                            @Override
                            public void proxyOperationHandlerCreated(final ManagementMessageHandler handler) {
                                channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                                    public void handleClose(Channel closed, IOException exception) {
                                        handler.shutdownNow();
                                    }
                                });
                                Channel.Receiver receiver = ManagementChannelReceiver.createDelegating((ManagementMessageHandler)handler);
                                mgmtChannel.receiveMessage(receiver);
                                ServerToHostOperationHandlerFactoryService.safeWriteResponse(channel, (ManagementProtocolHeader)header, null);
                            }
                        });
                    }
                });
            } else {
                ServerToHostOperationHandlerFactoryService.safeWriteResponse(channel, (ManagementProtocolHeader)header, HostControllerMessages.MESSAGES.unrecognizedType(type));
                channel.close();
            }
        }

        protected Channel.Receiver next() {
            return null;
        }
    }
}

