/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.jboss.as.cmp.ejbql.Catalog;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.JDBCParameterSetter;
import org.jboss.as.cmp.jdbc.JDBCType;
import org.jboss.as.cmp.jdbc.JDBCTypeComplex;
import org.jboss.as.cmp.jdbc.JDBCTypeComplexProperty;
import org.jboss.as.cmp.jdbc.JDBCTypeSimple;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.logging.Logger;

public final class QueryParameter {
    private int argNum;
    private final boolean isPrimaryKeyParameter;
    private JDBCFieldBridge field;
    private JDBCTypeComplexProperty property;
    private String parameterString;
    private int jdbcType;
    private JDBCType type;

    public static List createParameters(int argNum, JDBCFieldBridge field) {
        List<QueryParameter> parameters;
        JDBCType type = field.getJDBCType();
        if (type instanceof JDBCTypeComplex) {
            JDBCTypeComplexProperty[] props = ((JDBCTypeComplex)type).getProperties();
            parameters = new ArrayList<QueryParameter>(props.length);
            for (int i = 0; i < props.length; ++i) {
                QueryParameter param = new QueryParameter(argNum, false, null, props[i], props[i].getJDBCType());
                parameters.add(param);
            }
        } else {
            QueryParameter param = new QueryParameter(argNum, type);
            parameters = Collections.singletonList(param);
        }
        return parameters;
    }

    public static List createParameters(int argNum, JDBCAbstractEntityBridge entity) {
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        JDBCFieldBridge[] pkFields = entity.getPrimaryKeyFields();
        for (int i = 0; i < pkFields.length; ++i) {
            JDBCFieldBridge pkField = pkFields[i];
            JDBCType type = pkField.getJDBCType();
            if (type instanceof JDBCTypeComplex) {
                JDBCTypeComplexProperty[] props = ((JDBCTypeComplex)type).getProperties();
                for (int j = 0; j < props.length; ++j) {
                    QueryParameter param = new QueryParameter(argNum, false, pkField, props[j], props[j].getJDBCType());
                    parameters.add(param);
                }
                continue;
            }
            QueryParameter param = new QueryParameter(argNum, false, pkField, null, type.getJDBCTypes()[0]);
            param.type = type;
            parameters.add(param);
        }
        return parameters;
    }

    public static List createPrimaryKeyParameters(int argNum, JDBCAbstractEntityBridge entity) {
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        JDBCFieldBridge[] pkFields = entity.getPrimaryKeyFields();
        for (int i = 0; i < pkFields.length; ++i) {
            JDBCFieldBridge pkField = pkFields[i];
            JDBCType type = pkField.getJDBCType();
            if (type instanceof JDBCTypeComplex) {
                JDBCTypeComplexProperty[] props = ((JDBCTypeComplex)type).getProperties();
                for (int j = 0; j < props.length; ++j) {
                    QueryParameter param = new QueryParameter(argNum, true, pkField, props[j], props[j].getJDBCType());
                    parameters.add(param);
                }
                continue;
            }
            QueryParameter param = new QueryParameter(argNum, true, pkField, null, type.getJDBCTypes()[0]);
            param.type = type;
            parameters.add(param);
        }
        return parameters;
    }

    public QueryParameter(JDBCEntityPersistenceStore manager, Method method, String parameterString) {
        JDBCType type;
        this.isPrimaryKeyParameter = false;
        this.parameterString = parameterString;
        if (parameterString == null || parameterString.length() == 0) {
            throw new IllegalArgumentException("Parameter string is empty");
        }
        StringTokenizer tok = new StringTokenizer(parameterString, ".");
        try {
            this.argNum = Integer.parseInt(tok.nextToken());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The parameter must begin with a number");
        }
        if (this.argNum > method.getParameterTypes().length) {
            throw new IllegalArgumentException("The parameter index is " + this.argNum + " but the query method only has " + method.getParameterTypes().length + "parameter(s)");
        }
        Class<?> argType = method.getParameterTypes()[this.argNum];
        if (EJBObject.class.isAssignableFrom(argType) || EJBLocalObject.class.isAssignableFrom(argType)) {
            if (!tok.hasMoreTokens()) {
                throw new IllegalArgumentException("When the parameter is an ejb a field name must be supplied.");
            }
            String fieldName = tok.nextToken();
            this.field = QueryParameter.getCMPField(manager, argType, fieldName);
            if (!this.field.isPrimaryKeyMember()) {
                throw new IllegalArgumentException("The specified field must be a primay key field");
            }
            type = this.field.getJDBCType();
        } else {
            type = manager.getJDBCTypeFactory().getJDBCType(argType);
        }
        if (type instanceof JDBCTypeSimple) {
            if (tok.hasMoreTokens()) {
                throw new IllegalArgumentException("Parameter is NOT a known dependent value class, so a properties cannot supplied.");
            }
            this.jdbcType = type.getJDBCTypes()[0];
            this.type = type;
        } else {
            if (!tok.hasMoreTokens()) {
                throw new IllegalArgumentException("Parmeter is a known dependent value class, so a property must be supplied");
            }
            StringBuffer propertyName = new StringBuffer(parameterString.length());
            propertyName.append(tok.nextToken());
            while (tok.hasMoreTokens()) {
                propertyName.append('.').append(tok.nextToken());
            }
            this.property = ((JDBCTypeComplex)type).getProperty(propertyName.toString());
            this.jdbcType = this.property.getJDBCType();
        }
    }

    public QueryParameter(int argNum, JDBCType type) {
        this.argNum = argNum;
        this.type = type;
        this.jdbcType = type.getJDBCTypes()[0];
        this.isPrimaryKeyParameter = false;
        this.initToString();
    }

    public QueryParameter(int argNum, boolean isPrimaryKeyParameter, JDBCFieldBridge field, JDBCTypeComplexProperty property, int jdbcType) {
        this.argNum = argNum;
        this.isPrimaryKeyParameter = isPrimaryKeyParameter;
        this.field = field;
        this.property = property;
        this.jdbcType = jdbcType;
        this.initToString();
    }

    private void initToString() {
        StringBuffer parameterBuf = new StringBuffer();
        parameterBuf.append(this.argNum);
        if (this.field != null) {
            parameterBuf.append('.').append(this.field.getFieldName());
        }
        if (this.property != null) {
            parameterBuf.append('.').append(this.property.getPropertyName());
        }
        this.parameterString = parameterBuf.toString();
    }

    public void set(Logger log, PreparedStatement ps, int index, Object[] args) throws Exception {
        JDBCParameterSetter param;
        Object arg = args[this.argNum];
        if (this.field != null) {
            if (!this.isPrimaryKeyParameter) {
                if (arg instanceof EJBObject) {
                    arg = ((EJBObject)arg).getPrimaryKey();
                } else if (arg instanceof EJBLocalObject) {
                    arg = ((EJBLocalObject)arg).getPrimaryKey();
                } else {
                    throw new IllegalArgumentException("Expected an instanc of EJBObject or EJBLocalObject, but got an instance of " + arg.getClass().getName());
                }
            }
            arg = this.field.getPrimaryKeyValue(arg);
            JDBCType jdbcType = this.field.getJDBCType();
            arg = jdbcType.getColumnValue(0, arg);
            param = jdbcType.getParameterSetter()[0];
        } else if (this.property != null) {
            arg = this.property.getColumnValue(arg);
            param = this.property.getParameterSetter();
        } else if (this.type != null) {
            arg = this.type.getColumnValue(0, arg);
            param = this.type.getParameterSetter()[0];
        } else {
            param = JDBCUtil.getParameterSetter(this.jdbcType, arg == null ? null : arg.getClass());
        }
        param.set(ps, index, this.jdbcType, arg, log);
    }

    private static JDBCFieldBridge getCMPField(JDBCEntityPersistenceStore manager, Class intf, String fieldName) {
        Catalog catalog = manager.getCatalog();
        JDBCAbstractEntityBridge entityBridge = (JDBCAbstractEntityBridge)catalog.getEntityByInterface(intf);
        if (entityBridge == null) {
            throw new IllegalArgumentException("Entity not found in application catalog with interface=" + intf.getName());
        }
        JDBCFieldBridge cmpField = (JDBCFieldBridge)entityBridge.getFieldByName(fieldName);
        if (cmpField == null) {
            throw new IllegalArgumentException("cmpField not found: cmpFieldName=" + fieldName + " entityName=" + entityBridge.getEntityName());
        }
        return cmpField;
    }

    public String toString() {
        return this.parameterString;
    }
}

