/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cmp.jdbc.metadata.JDBCLeftJoinMetaData;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedReadAhead;

public class JDBCReadAheadMetaData {
    public static final JDBCReadAheadMetaData DEFAULT = new JDBCReadAheadMetaData();
    private static final byte NONE = 0;
    private static final byte ON_LOAD = 1;
    private static final byte ON_FIND = 2;
    private static final List<String> STRATEGIES = Arrays.asList("none", "on-load", "on-find");
    private final byte strategy;
    private final int pageSize;
    private final String eagerLoadGroup;
    private final List<JDBCLeftJoinMetaData> leftJoinList;

    private JDBCReadAheadMetaData() {
        this.strategy = 1;
        this.pageSize = 255;
        this.eagerLoadGroup = "*";
        this.leftJoinList = Collections.emptyList();
    }

    public JDBCReadAheadMetaData(ParsedReadAhead parsed, JDBCReadAheadMetaData defaultValue) {
        this.strategy = (byte)STRATEGIES.indexOf(parsed.getStrategy());
        if (this.strategy < 0) {
            throw new RuntimeException("Unknown read ahead strategy '" + parsed.getStrategy() + "'.");
        }
        if (parsed.getPageSize() != null) {
            this.pageSize = parsed.getPageSize();
            if (this.pageSize < 0) {
                throw new RuntimeException("Negative value for read ahead page-size '" + parsed.getPageSize() + "'.");
            }
        } else {
            this.pageSize = defaultValue.getPageSize();
        }
        this.eagerLoadGroup = parsed.getEagerLoadGroup() != null ? parsed.getEagerLoadGroup() : defaultValue.getEagerLoadGroup();
        this.leftJoinList = parsed.getLeftJoinList();
    }

    public boolean isNone() {
        return this.strategy == 0;
    }

    public boolean isOnLoad() {
        return this.strategy == 1;
    }

    public boolean isOnFind() {
        return this.strategy == 2;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getEagerLoadGroup() {
        return this.eagerLoadGroup;
    }

    public List<JDBCLeftJoinMetaData> getLeftJoins() {
        return this.leftJoinList;
    }

    public String toString() {
        return "[JDBCReadAheadMetaData : strategy=" + STRATEGIES.get(this.strategy) + ", pageSize=" + this.pageSize + ", eagerLoadGroup=" + this.eagerLoadGroup + ", left-join" + this.leftJoinList + "]";
    }
}

