/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing;

import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.impl.backing.PassivatingBackingCacheImpl;
import org.jboss.as.ejb3.cache.impl.backing.SerializationGroupMemberContainer;
import org.jboss.as.ejb3.cache.spi.GroupAwareBackingCache;
import org.jboss.as.ejb3.cache.spi.PassivatingBackingCache;
import org.jboss.as.ejb3.cache.spi.SerializationGroup;
import org.jboss.as.ejb3.cache.spi.SerializationGroupMember;

public class GroupAwareBackingCacheImpl<K extends Serializable, V extends Cacheable<K>, G extends Serializable>
extends PassivatingBackingCacheImpl<K, V, SerializationGroupMember<K, V, G>>
implements GroupAwareBackingCache<K, V, G, SerializationGroupMember<K, V, G>> {
    private final PassivatingBackingCache<G, Cacheable<G>, SerializationGroup<K, V, G>> groupCache;
    private final SerializationGroupMemberContainer<K, V, G> memberContainer;

    public GroupAwareBackingCacheImpl(StatefulObjectFactory<V> factory, SerializationGroupMemberContainer<K, V, G> memberContainer, PassivatingBackingCache<G, Cacheable<G>, SerializationGroup<K, V, G>> groupCache, ThreadFactory threadFactory) {
        super(factory, memberContainer, memberContainer, memberContainer, threadFactory);
        this.groupCache = groupCache;
        this.memberContainer = memberContainer;
        this.memberContainer.setBackingCache(this);
    }

    public GroupAwareBackingCacheImpl(StatefulObjectFactory<V> factory, SerializationGroupMemberContainer<K, V, G> memberContainer, PassivatingBackingCache<G, Cacheable<G>, SerializationGroup<K, V, G>> groupCache, ScheduledExecutorService executor) {
        super(factory, memberContainer, memberContainer, memberContainer, executor);
        this.groupCache = groupCache;
        this.memberContainer = memberContainer;
        this.memberContainer.setBackingCache(this);
    }

    @Override
    public SerializationGroup<K, V, G> createGroup() {
        return (SerializationGroup)this.groupCache.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGroup(V object, SerializationGroup<K, V, G> group) {
        Serializable key = (Serializable)object.getId();
        SerializationGroupMember entry = (SerializationGroupMember)this.peek(key);
        entry.lock();
        try {
            if (entry.getGroup() != null) {
                throw EjbMessages.MESSAGES.existingSerializationGroup(key, entry.getGroup());
            }
            if (!this.memberContainer.isCompatibleWith(group)) {
                throw EjbMessages.MESSAGES.incompatibleSerializationGroup(object, group);
            }
            entry.setGroup(group);
            entry.getGroup().addMember(entry);
        }
        finally {
            entry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPreReplicate(SerializationGroupMember<K, V, G> entry) {
        this.log.tracef("notifyPreReplicate(%s)", entry);
        if (!entry.isPreReplicated()) {
            if (!entry.tryLock()) {
                throw EjbMessages.MESSAGES.cacheEntryInUse(entry);
            }
            try {
                if (entry.isInUse()) {
                    throw EjbMessages.MESSAGES.cacheEntryInUse(entry);
                }
                this.memberContainer.preReplicate(entry);
                entry.setPreReplicated(true);
            }
            finally {
                entry.unlock();
            }
        }
    }
}

