/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.spi.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.spi.PersistentObjectStore;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;

public class FilePersistentObjectStore<K extends Serializable, V extends Cacheable<K>>
implements PersistentObjectStore<K, V> {
    private static final Logger log = Logger.getLogger(FilePersistentObjectStore.class);
    private final MarshallerFactory marshallerFactory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)MarshallerFactory.class.getClassLoader());
    private final MarshallingConfiguration configuration;
    private final int subdirectoryCount;
    private final File baseDirectory;
    private File[] storageDirectories;

    public FilePersistentObjectStore(MarshallingConfiguration configuration, String directoryName, int subDirectoryCount) {
        this.configuration = configuration;
        this.baseDirectory = new File(directoryName);
        this.subdirectoryCount = subDirectoryCount;
    }

    protected File getFile(K key) {
        File base = null;
        if (this.storageDirectories != null) {
            int hash = (key.hashCode() & Integer.MAX_VALUE) % this.storageDirectories.length;
            base = this.storageDirectories[hash];
        } else {
            base = this.baseDirectory;
        }
        return new File(base, String.valueOf(key) + ".ser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V load(K key) {
        File file = this.getFile(key);
        if (!file.exists()) {
            return null;
        }
        log.tracef("Loading state from %s", (Object)file);
        try {
            Unmarshaller unmarshaller = this.marshallerFactory.createUnmarshaller(this.configuration);
            unmarshaller.start(Marshalling.createByteInput((InputStream)FISAction.open(file)));
            try {
                Cacheable value = (Cacheable)unmarshaller.readObject();
                unmarshaller.finish();
                Cacheable cacheable = value;
                return (V)cacheable;
            }
            finally {
                unmarshaller.close();
                DeleteFileAction.delete(file);
            }
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.activationFailed(e, key);
        }
    }

    @Override
    public void start() {
        this.establishDirectory(this.baseDirectory);
        if (this.subdirectoryCount > 1) {
            this.storageDirectories = new File[this.subdirectoryCount];
            for (int i = 0; i < this.storageDirectories.length; ++i) {
                File f = new File(this.baseDirectory, String.valueOf(i) + File.separatorChar);
                this.establishDirectory(f);
                this.storageDirectories[i] = f;
            }
        }
    }

    private void establishDirectory(File dir) {
        if (!dir.exists()) {
            if (!MkdirsFileAction.mkdirs(dir)) {
                throw EjbMessages.MESSAGES.passivationDirectoryCreationFailed(dir.getPath());
            }
            dir.deleteOnExit();
        }
        if (!dir.isDirectory()) {
            throw EjbMessages.MESSAGES.passivationPathNotADirectory(dir.getPath());
        }
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(V obj) {
        File file = this.getFile((Serializable)obj.getId());
        file.deleteOnExit();
        log.tracef("Storing state to %s", (Object)file);
        try {
            Marshaller marshaller = this.marshallerFactory.createMarshaller(this.configuration);
            marshaller.start(Marshalling.createByteOutput((OutputStream)FOSAction.open(file)));
            try {
                marshaller.writeObject(obj);
                marshaller.finish();
            }
            finally {
                marshaller.close();
            }
        }
        catch (IOException e) {
            throw EjbMessages.MESSAGES.passivationFailed(e, obj.getId());
        }
    }

    private static class MkdirsFileAction
    implements PrivilegedAction<Boolean> {
        File file;

        MkdirsFileAction(File file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            return this.file.mkdirs();
        }

        static boolean mkdirs(File file) {
            MkdirsFileAction action = new MkdirsFileAction(file);
            return AccessController.doPrivileged(action);
        }
    }

    private static class FOSAction
    implements PrivilegedExceptionAction<FileOutputStream> {
        File file;

        FOSAction(File file) {
            this.file = file;
        }

        @Override
        public FileOutputStream run() throws FileNotFoundException {
            FileOutputStream fis = new FileOutputStream(this.file);
            return fis;
        }

        static FileOutputStream open(File file) throws FileNotFoundException {
            FOSAction action = new FOSAction(file);
            FileOutputStream fos = null;
            try {
                fos = AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (FileNotFoundException)e.getException();
            }
            return fos;
        }
    }

    private static class FISAction
    implements PrivilegedExceptionAction<FileInputStream> {
        File file;

        FISAction(File file) {
            this.file = file;
        }

        @Override
        public FileInputStream run() throws FileNotFoundException {
            FileInputStream fis = new FileInputStream(this.file);
            return fis;
        }

        static FileInputStream open(File file) throws FileNotFoundException {
            FISAction action = new FISAction(file);
            FileInputStream fis = null;
            try {
                fis = AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (FileNotFoundException)e.getException();
            }
            return fis;
        }
    }

    private static class DeleteFileAction
    implements PrivilegedAction<Boolean> {
        File file;

        DeleteFileAction(File file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            return this.file.delete();
        }

        static boolean delete(File file) {
            DeleteFileAction action = new DeleteFileAction(file);
            return AccessController.doPrivileged(action);
        }
    }
}

