/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.deployment.processors.dd.MethodResolutionUtils;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;

public class SessionPassivationMergingProcessor
extends AbstractMergingProcessor<StatefulComponentDescription> {
    public SessionPassivationMergingProcessor() {
        super(StatefulComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, StatefulComponentDescription description) throws DeploymentUnitProcessingException {
        RuntimeAnnotationInformation postActivate;
        RuntimeAnnotationInformation prePassivate = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, PrePassivate.class);
        Map annotations = prePassivate.getMethodAnnotations();
        if (!annotations.isEmpty()) {
            for (Method method : annotations.keySet()) {
                description.addPrePassivateMethod(method);
            }
        }
        if (!(annotations = (postActivate = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, PostActivate.class)).getMethodAnnotations()).isEmpty()) {
            for (Method method : annotations.keySet()) {
                description.addPostActivateMethod(method);
            }
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, StatefulComponentDescription description) throws DeploymentUnitProcessingException {
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        SessionBeanMetaData data = description.getDescriptorData();
        if (data != null) {
            LifecycleCallbacksMetaData callbacks = data.getPrePassivates();
            if (callbacks != null) {
                for (LifecycleCallbackMetaData callback : callbacks) {
                    description.addPrePassivateMethod(MethodResolutionUtils.resolveMethod(callback.getMethodName(), null, componentClass, reflectionIndex));
                }
            }
            if ((callbacks = data.getPostActivates()) != null) {
                for (LifecycleCallbackMetaData callback : callbacks) {
                    description.addPostActivateMethod(MethodResolutionUtils.resolveMethod(callback.getMethodName(), null, componentClass, reflectionIndex));
                }
            }
        }
    }
}

