/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.threads.QueuelessThreadPoolService;
import org.jboss.as.threads.ThreadPoolReadAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;

public class QueuelessThreadPoolReadAttributeHandler
extends ThreadPoolReadAttributeHandler {
    public static final List<String> METRICS = Arrays.asList("current-thread-count", "largest-thread-count", "rejected-count");
    public static final QueuelessThreadPoolReadAttributeHandler INSTANCE = new QueuelessThreadPoolReadAttributeHandler();

    public QueuelessThreadPoolReadAttributeHandler() {
        super(METRICS);
    }

    @Override
    protected void setResult(OperationContext context, String attributeName, Service<?> service) throws OperationFailedException {
        QueuelessThreadPoolService pool = (QueuelessThreadPoolService)service;
        if (attributeName.equals("current-thread-count")) {
            context.getResult().set(pool.getCurrentThreadCount());
        } else if (attributeName.equals("largest-thread-count")) {
            context.getResult().set(pool.getLargestThreadCount());
        } else if (attributeName.equals("rejected-count")) {
            context.getResult().set(pool.getRejectedCount());
        } else if (METRICS.contains(attributeName)) {
            throw new OperationFailedException(new ModelNode().set("Unsupported attribute '" + attributeName + "'"));
        }
    }
}

