/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.context;

import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.jboss.jsfunit.context.JSFUnitFacesContext;
import org.jboss.jsfunit.framework.WebConversationFactory;

public class JSFUnitFacesContextFactory
extends FacesContextFactory {
    private FacesContextFactory parent;

    public JSFUnitFacesContextFactory(FacesContextFactory parent) {
        this.parent = parent;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (this.isJSFUnitRequest(req)) {
            FacesContext realFacesContext = this.parent.getFacesContext(context, request, response, lifecycle);
            return new JSFUnitFacesContext(realFacesContext);
        }
        return this.parent.getFacesContext(context, request, response, lifecycle);
    }

    private boolean isJSFUnitRequest(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return false;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(WebConversationFactory.JSF_UNIT_CONVERSATION_FLAG)) continue;
            return true;
        }
        return false;
    }
}

