/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.rmi.ir;

import org.jboss.as.jacorb.rmi.ir.IRConstructionException;
import org.jboss.as.jacorb.rmi.ir.RepositoryImpl;
import org.jboss.logging.Logger;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.IRObjectOperations;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

abstract class IRObjectImpl
implements IRObjectOperations {
    protected RepositoryImpl repository;
    protected final DefinitionKind def_kind;
    private static final Logger logger = Logger.getLogger(IRObjectImpl.class);

    IRObjectImpl(DefinitionKind def_kind, RepositoryImpl repository) {
        this.def_kind = def_kind;
        this.repository = repository;
    }

    public DefinitionKind def_kind() {
        logger.trace((java.lang.Object)"IRObjectImpl.def_kind() entered.");
        return this.def_kind;
    }

    public void destroy() {
        throw new BAD_INV_ORDER("Cannot destroy RMI/IIOP mapping.", 2, CompletionStatus.COMPLETED_NO);
    }

    public abstract IRObject getReference();

    public void allDone() throws IRConstructionException {
        this.getReference();
    }

    public void shutdown() {
        POA poa = this.getPOA();
        try {
            poa.deactivate_object(poa.reference_to_id((Object)this.getReference()));
        }
        catch (UserException ex) {
            logger.warn((java.lang.Object)"Could not deactivate IR object", (Throwable)ex);
        }
    }

    public RepositoryImpl getRepository() {
        return this.repository;
    }

    protected ORB getORB() {
        return this.repository.orb;
    }

    protected POA getPOA() {
        return this.repository.poa;
    }

    protected abstract byte[] getObjectId();

    protected Object servantToReference(Servant servant) {
        byte[] id = this.getObjectId();
        try {
            logger.debug((java.lang.Object)("#### IRObject.srv2ref: id=[" + new String(id) + "]"));
            this.repository.poa.activate_object_with_id(id, servant);
            Object ref = this.repository.poa.id_to_reference(id);
            logger.debug((java.lang.Object)"#### IRObject.srv2ref: returning ref.");
            return ref;
        }
        catch (WrongPolicy ex) {
            logger.debug((java.lang.Object)"Exception converting CORBA servant to reference", (Throwable)ex);
        }
        catch (ServantAlreadyActive ex) {
            logger.debug((java.lang.Object)"Exception converting CORBA servant to reference", (Throwable)ex);
        }
        catch (ObjectAlreadyActive ex) {
            logger.debug((java.lang.Object)"Exception converting CORBA servant to reference", (Throwable)ex);
        }
        catch (ObjectNotActive ex) {
            logger.debug((java.lang.Object)"Exception converting CORBA servant to reference", (Throwable)ex);
        }
        return null;
    }
}

