/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.SocketFactory;
import org.jboss.as.jacorb.security.Util;
import org.jboss.logging.Logger;
import org.jboss.security.JSSESecurityDomain;
import org.omg.CORBA.TIMEOUT;

public class DomainSocketFactory
implements SocketFactory,
Configurable {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.security");
    private SSLContext sslContext;
    private JSSESecurityDomain jsseSecurityDomain;

    public DomainSocketFactory(ORB orb) {
        log.tracef("Creating socket factory: %s", (Object)this.getClass().getName());
    }

    public Socket createSocket(String host, int port) throws IOException {
        this.initSSLContext();
        InetAddress address = InetAddress.getByName(host);
        SSLSocketFactory socketFactory = this.sslContext.getSocketFactory();
        SSLSocket socket = (SSLSocket)socketFactory.createSocket(address, port);
        if (this.jsseSecurityDomain.getProtocols() != null) {
            socket.setEnabledProtocols(this.jsseSecurityDomain.getProtocols());
        }
        if (this.jsseSecurityDomain.getCipherSuites() != null) {
            socket.setEnabledCipherSuites(this.jsseSecurityDomain.getCipherSuites());
        }
        socket.setNeedClientAuth(this.jsseSecurityDomain.isClientAuth());
        return socket;
    }

    public Socket createSocket(String host, int port, int timeout) throws IOException, TIMEOUT {
        this.initSSLContext();
        InetAddress address = InetAddress.getByName(host);
        SSLSocketFactory socketFactory = this.sslContext.getSocketFactory();
        SSLSocket socket = (SSLSocket)socketFactory.createSocket();
        socket.connect(new InetSocketAddress(address, port), timeout);
        if (this.jsseSecurityDomain.getProtocols() != null) {
            socket.setEnabledProtocols(this.jsseSecurityDomain.getProtocols());
        }
        if (this.jsseSecurityDomain.getCipherSuites() != null) {
            socket.setEnabledCipherSuites(this.jsseSecurityDomain.getCipherSuites());
        }
        socket.setNeedClientAuth(this.jsseSecurityDomain.isClientAuth());
        return socket;
    }

    public boolean isSSL(Socket socket) {
        return socket instanceof SSLSocket;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        String securityDomain = configuration.getAttribute("security-domain");
        if (securityDomain == null) {
            throw new ConfigurationException("Error configuring domain socket factory: security domain is null");
        }
        try {
            InitialContext context = new InitialContext();
            this.jsseSecurityDomain = (JSSESecurityDomain)context.lookup("java:jboss/jaas/" + securityDomain + "/jsse");
            log.debugf("Obtained JSSE security domain with name %s", (Object)securityDomain);
        }
        catch (NamingException ne) {
            log.errorf("Failed to obtain JSSE security domain with name %s", (Object)securityDomain);
            throw new ConfigurationException("Error configuring domain socket factory: failed to lookup JSSE security domain");
        }
    }

    private void initSSLContext() throws IOException {
        if (this.sslContext != null) {
            return;
        }
        this.sslContext = Util.forDomain(this.jsseSecurityDomain);
    }
}

