/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.spi.util.UnmodifiableDictionary;

public class SubsystemState
extends Observable
implements Serializable,
Service<SubsystemState> {
    private static final long serialVersionUID = 6268537612248019022L;
    public static final ServiceName SERVICE_NAME = FrameworkBootstrapService.FRAMEWORK_BASE_NAME.append(new String[]{"subsystemstate"});
    public static final String PROP_JBOSS_OSGI_SYSTEM_MODULES = "org.jboss.osgi.system.modules";
    public static final String PROP_JBOSS_OSGI_SYSTEM_PACKAGES = "org.jboss.osgi.system.packages";
    public static final String PROP_JBOSS_OSGI_SYSTEM_MODULES_EXTRA = "org.jboss.osgi.system.modules.extra";
    private final Map<String, Dictionary<String, String>> configurations = new LinkedHashMap<String, Dictionary<String, String>>();
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final List<OSGiCapability> capabilities = new ArrayList<OSGiCapability>();
    private volatile Activation activationPolicy = Activation.LAZY;
    static final Activation DEFAULT_ACTIVATION = Activation.LAZY;

    public static ServiceController<SubsystemState> addService(ServiceTarget serviceTarget, Activation activation) {
        SubsystemState state = new SubsystemState();
        state.setActivation(activation);
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)state);
        builder.setInitialMode(ServiceController.Mode.LAZY);
        return builder.install();
    }

    static SubsystemState getSubsystemState(OperationContext context) {
        ServiceController controller = context.getServiceRegistry(true).getService(SERVICE_NAME);
        return controller != null ? (SubsystemState)controller.getValue() : null;
    }

    SubsystemState() {
    }

    public SubsystemState getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getConfigurations() {
        Map<String, Dictionary<String, String>> map = this.configurations;
        synchronized (map) {
            Set<String> values = this.configurations.keySet();
            return Collections.unmodifiableSet(new HashSet<String>(values));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConfiguration(String pid) {
        Map<String, Dictionary<String, String>> map = this.configurations;
        synchronized (map) {
            return this.configurations.containsKey(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<String, String> getConfiguration(String pid) {
        Map<String, Dictionary<String, String>> map = this.configurations;
        synchronized (map) {
            return this.configurations.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<String, String> putConfiguration(String pid, Dictionary<String, String> props) {
        try {
            Map<String, Dictionary<String, String>> map = this.configurations;
            synchronized (map) {
                Dictionary<String, String> dictionary = this.configurations.put(pid, (Dictionary<String, String>)new UnmodifiableDictionary(props));
                return dictionary;
            }
        }
        finally {
            this.notifyObservers(new ChangeEvent(ChangeType.CONFIG, false, pid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<String, String> removeConfiguration(String pid) {
        try {
            Map<String, Dictionary<String, String>> map = this.configurations;
            synchronized (map) {
                Dictionary<String, String> dictionary = this.configurations.remove(pid);
                return dictionary;
            }
        }
        finally {
            this.notifyObservers(new ChangeEvent(ChangeType.CONFIG, true, pid));
        }
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object setProperty(String name, Object value) {
        block3: {
            try {
                if (value != null) break block3;
                Object object = this.properties.remove(name);
                this.notifyObservers(new ChangeEvent(ChangeType.PROPERTY, value == null, name));
                return object;
            }
            catch (Throwable throwable) {
                this.notifyObservers(new ChangeEvent(ChangeType.PROPERTY, value == null, name));
                throw throwable;
            }
        }
        Object object = this.properties.put(name, value);
        this.notifyObservers(new ChangeEvent(ChangeType.PROPERTY, value == null, name));
        return object;
    }

    public List<OSGiCapability> getCapabilities() {
        return Collections.unmodifiableList(this.capabilities);
    }

    public void addCapability(OSGiCapability module) {
        this.capabilities.add(module);
        this.notifyObservers(new ChangeEvent(ChangeType.CAPABILITY, false, module.getIdentifier().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSGiCapability removeCapability(String id) {
        ModuleIdentifier identifier = ModuleIdentifier.fromString((String)id);
        List<OSGiCapability> list = this.capabilities;
        synchronized (list) {
            Iterator<OSGiCapability> it = this.capabilities.iterator();
            while (it.hasNext()) {
                OSGiCapability module = it.next();
                if (!module.getIdentifier().equals(identifier)) continue;
                it.remove();
                this.notifyObservers(new ChangeEvent(ChangeType.CAPABILITY, true, identifier.toString()));
                return module;
            }
            return null;
        }
    }

    public Activation getActivationPolicy() {
        return this.activationPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActivation(Activation activation) {
        if (this.activationPolicy == activation) {
            return;
        }
        try {
            this.activationPolicy = activation;
        }
        finally {
            this.notifyObservers(new ChangeEvent(ChangeType.ACTIVATION, false, activation.name()));
        }
    }

    @Override
    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    public static enum ChangeType {
        ACTIVATION,
        CONFIG,
        PROPERTY,
        CAPABILITY;

    }

    public static class ChangeEvent {
        private final String id;
        private final boolean isRemoved;
        private final ChangeType type;

        public ChangeEvent(ChangeType type, boolean isRemoved, String id) {
            this.type = type;
            this.isRemoved = isRemoved;
            this.id = id;
        }

        public ChangeType getType() {
            return this.type;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class OSGiCapability
    implements Serializable {
        private static final long serialVersionUID = -2280880859263752474L;
        private final ModuleIdentifier identifier;
        private final Integer startlevel;

        public OSGiCapability(ModuleIdentifier identifier, Integer startlevel) {
            this.identifier = identifier;
            this.startlevel = startlevel;
        }

        public ModuleIdentifier getIdentifier() {
            return this.identifier;
        }

        public Integer getStartLevel() {
            return this.startlevel;
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OSGiCapability)) {
                return false;
            }
            OSGiCapability om = (OSGiCapability)obj;
            return this.identifier == null ? om.identifier == null : this.identifier.equals(om.identifier);
        }
    }

    public static enum Activation {
        EAGER,
        LAZY;

    }
}

