/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.AbstractDelegatingAdvancedCache;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheImpl;
import org.infinispan.context.Flag;
import org.infinispan.util.concurrent.NotifyingFuture;

public class DecoratedCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    private EnumSet<Flag> flags;
    private ClassLoader classLoader;
    private final CacheImpl<K, V> cacheImplementation;

    public DecoratedCache(AdvancedCache<K, V> delegate, ClassLoader classLoader) {
        this(delegate, classLoader, null);
    }

    public DecoratedCache(AdvancedCache<K, V> delegate, Flag ... flags) {
        this(delegate, (ClassLoader)null, flags);
    }

    public DecoratedCache(AdvancedCache<K, V> delegate, ClassLoader classLoader, Flag ... flags) {
        super(delegate);
        if (flags == null || flags.length == 0) {
            this.flags = null;
        } else {
            this.flags = EnumSet.noneOf(Flag.class);
            this.flags.addAll(Arrays.asList(flags));
        }
        this.classLoader = classLoader;
        if (flags == null && classLoader == null) {
            throw new IllegalArgumentException("There is no point in using a DecoratedCache if neither a ClassLoader nor any Flags are set.");
        }
        this.cacheImplementation = (CacheImpl)delegate;
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("ClassLoader passed in cannot be null!");
        }
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        if (flags == null) {
            throw new NullPointerException("Flags cannot be null!");
        }
        if (this.flags == null) {
            this.flags = EnumSet.noneOf(Flag.class);
        }
        this.flags.addAll(Arrays.asList(flags));
        return this;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return this.cacheImplementation.getClassLoader();
        }
        return this.classLoader;
    }

    @Override
    public void stop() {
        this.cacheImplementation.stop(this.flags, this.classLoader);
    }

    @Override
    public boolean lock(K ... keys) {
        return this.cacheImplementation.lock((Collection<K>)Arrays.asList(keys), this.flags, this.classLoader);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return this.cacheImplementation.lock(keys, this.flags, this.classLoader);
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.cacheImplementation.putForExternalRead(key, value, this.flags, this.classLoader);
    }

    @Override
    public void evict(K key) {
        this.cacheImplementation.evict(key, this.flags, this.classLoader);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        return this.cacheImplementation.put(key, value, lifespan, unit, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return this.cacheImplementation.putIfAbsent(key, value, lifespan, unit, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.cacheImplementation.putAll(map, lifespan, unit, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        return this.cacheImplementation.replace(key, value, lifespan, unit, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.cacheImplementation.replace(key, oldValue, value, lifespan, unit, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cacheImplementation.put(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, this.flags, this.classLoader);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cacheImplementation.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, this.flags, this.classLoader);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.cacheImplementation.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, this.flags, this.classLoader);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cacheImplementation.replace(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, this.flags, this.classLoader);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cacheImplementation.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value) {
        return this.cacheImplementation.putAsync(key, value, this.cacheImplementation.defaultLifespan, TimeUnit.MILLISECONDS, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cacheImplementation.putAsync(key, value, lifespan, unit, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cacheImplementation.putAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.cacheImplementation.putAllAsync(data, this.cacheImplementation.defaultLifespan, TimeUnit.MILLISECONDS, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.cacheImplementation.putAllAsync(data, lifespan, unit, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cacheImplementation.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<Void> clearAsync() {
        return this.cacheImplementation.clearAsync(this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value) {
        return this.cacheImplementation.putIfAbsentAsync(key, value, this.cacheImplementation.defaultLifespan, TimeUnit.MILLISECONDS, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cacheImplementation.putIfAbsentAsync(key, value, lifespan, unit, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cacheImplementation.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<V> removeAsync(Object key) {
        return this.cacheImplementation.removeAsync(key, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        return this.cacheImplementation.removeAsync(key, value, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value) {
        return this.cacheImplementation.replaceAsync(key, value, this.cacheImplementation.defaultLifespan, TimeUnit.MILLISECONDS, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cacheImplementation.replaceAsync(key, value, lifespan, unit, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cacheImplementation.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, this.cacheImplementation.defaultLifespan, TimeUnit.MILLISECONDS, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, lifespan, unit, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit, this.flags, this.classLoader);
    }

    @Override
    public NotifyingFuture<V> getAsync(K key) {
        return this.cacheImplementation.getAsync(key, this.flags, this.classLoader);
    }

    @Override
    public int size() {
        return this.cacheImplementation.size(this.flags, this.classLoader);
    }

    @Override
    public boolean isEmpty() {
        return this.cacheImplementation.isEmpty(this.flags, this.classLoader);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cacheImplementation.containsKey(key, this.flags, this.classLoader);
    }

    @Override
    public V get(Object key) {
        return this.cacheImplementation.get(key, this.flags, this.classLoader);
    }

    @Override
    public V put(K key, V value) {
        return this.cacheImplementation.put(key, value, this.cacheImplementation.defaultLifespan, TimeUnit.MILLISECONDS, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public V remove(Object key) {
        return this.cacheImplementation.remove(key, this.flags, this.classLoader);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.cacheImplementation.putAll(m, this.cacheImplementation.defaultLifespan, TimeUnit.MILLISECONDS, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public void clear() {
        this.cacheImplementation.clear(this.flags, this.classLoader);
    }

    @Override
    public Set<K> keySet() {
        return this.cacheImplementation.keySet(this.flags, this.classLoader);
    }

    @Override
    public Collection<V> values() {
        return this.cacheImplementation.values(this.flags, this.classLoader);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.cacheImplementation.entrySet(this.flags, this.classLoader);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.cacheImplementation.putIfAbsent(key, value, this.cacheImplementation.defaultLifespan, TimeUnit.MILLISECONDS, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.cacheImplementation.remove(key, value, this.flags, this.classLoader);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.cacheImplementation.replace(key, oldValue, newValue, this.cacheImplementation.defaultLifespan, TimeUnit.MILLISECONDS, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }

    @Override
    public V replace(K key, V value) {
        return this.cacheImplementation.replace(key, value, this.cacheImplementation.defaultLifespan, TimeUnit.MILLISECONDS, this.cacheImplementation.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.flags, this.classLoader);
    }
}

