/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import java.io.ByteArrayOutputStream;
import net.jcip.annotations.Immutable;

@Immutable
public class Version {
    private static final String MAJOR = "5";
    private static final String MINOR = "1";
    private static final String MICRO = "0";
    private static final String MODIFIER = "CR1";
    private static final boolean SNAPSHOT = false;
    public static String VERSION = String.format("%s.%s.%s%s%s", "5", "1", "0", ".", "CR1");
    public static String CODENAME = "Brahma";
    public static final String PROJECT_NAME = "Infinispan";
    public static byte[] VERSION_ID = Version.readVersionBytes();
    public static final String MAJOR_MINOR = "5.1";
    private static final int MAJOR_SHIFT = 11;
    private static final int MINOR_SHIFT = 6;
    private static final int MAJOR_MASK = 63488;
    private static final int MINOR_MASK = 1984;
    private static final int PATCH_MASK = 63;

    private static byte[] readVersionBytes() {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (i = 0; i < MAJOR.length(); ++i) {
            baos.write(MAJOR.charAt(i));
        }
        for (i = 0; i < MINOR.length(); ++i) {
            baos.write(MINOR.charAt(i));
        }
        for (i = 0; i < MICRO.length(); ++i) {
            baos.write(MICRO.charAt(i));
        }
        for (i = 0; i < MODIFIER.length(); ++i) {
            baos.write(MODIFIER.charAt(i));
        }
        return baos.toByteArray();
    }

    public static void main(String[] args) {
        Version.printFullVersionInformation();
    }

    public static void printFullVersionInformation() {
        System.out.println(PROJECT_NAME);
        System.out.println();
        System.out.printf("Version: \t%s\n", VERSION);
        System.out.printf("Codename: \t%s\n", CODENAME);
        System.out.println("History: \t(see https://jira.jboss.org/jira/browse/ISPN for details)\n");
    }

    public static String printVersion() {
        return "Infinispan '" + CODENAME + "' " + VERSION;
    }

    public static String printVersionId(byte[] v, int len) {
        StringBuilder sb = new StringBuilder();
        if (v != null) {
            if (len <= 0) {
                len = v.length;
            }
            for (int i = 0; i < len; ++i) {
                sb.append((char)v[i]);
            }
        }
        return sb.toString();
    }

    public static boolean compareTo(byte[] v) {
        if (v == null) {
            return false;
        }
        if (v.length < VERSION_ID.length) {
            return false;
        }
        for (int i = 0; i < VERSION_ID.length; ++i) {
            if (VERSION_ID[i] == v[i]) continue;
            return false;
        }
        return true;
    }

    public static int getLength() {
        return VERSION_ID.length;
    }

    public static short getVersionShort() {
        return Version.getVersionShort(VERSION);
    }

    public static short getVersionShort(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("versionString is null");
        }
        String[] parts = Version.getParts(versionString);
        int a = 0;
        int b = 0;
        int c = 0;
        if (parts.length > 0) {
            a = Integer.parseInt(parts[0]);
        }
        if (parts.length > 1) {
            b = Integer.parseInt(parts[1]);
        }
        if (parts.length > 2) {
            c = Integer.parseInt(parts[2]);
        }
        return Version.encodeVersion(a, b, c);
    }

    public static short encodeVersion(int major, int minor, int patch) {
        return (short)((major << 11) + (minor << 6) + patch);
    }

    public static String decodeVersion(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        int patch = version & 0x3F;
        return major + "." + minor + "." + patch;
    }

    public static String decodeVersionForSerialization(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        return major + "." + minor;
    }

    private static String[] getParts(String versionString) {
        return versionString.split("[\\.\\-]");
    }
}

