/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.transaction.xa.Xid;
import org.infinispan.Cache;
import org.infinispan.atomic.Delta;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.MapReduceCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.VersionedPutKeyValueCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CommandsFactoryImpl
implements CommandsFactory {
    private static final Log log = LogFactory.getLog(CommandsFactoryImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private DataContainer dataContainer;
    private CacheNotifier notifier;
    private Cache cache;
    private String cacheName;
    SizeCommand cachedSizeCommand;
    KeySetCommand cachedKeySetCommand;
    ValuesCommand cachedValuesCommand;
    EntrySetCommand cachedEntrySetCommand;
    private InterceptorChain interceptorChain;
    private DistributionManager distributionManager;
    private InvocationContextContainer icc;
    private TransactionTable txTable;
    private Configuration configuration;
    private RecoveryManager recoveryManager;
    private StateTransferManager stateTransferManager;
    private LockManager lockManager;
    private Map<Byte, ModuleCommandInitializer> moduleCommandInitializers;

    @Inject
    public void setupDependencies(DataContainer container, CacheNotifier notifier, Cache cache, InterceptorChain interceptorChain, DistributionManager distributionManager, InvocationContextContainer icc, TransactionTable txTable, Configuration configuration, @ComponentName(value="org.infinispan.modules.command.initializers") Map<Byte, ModuleCommandInitializer> moduleCommandInitializers, RecoveryManager recoveryManager, StateTransferManager stateTransferManager, LockManager lockManager) {
        this.dataContainer = container;
        this.notifier = notifier;
        this.cache = cache;
        this.interceptorChain = interceptorChain;
        this.distributionManager = distributionManager;
        this.icc = icc;
        this.txTable = txTable;
        this.configuration = configuration;
        this.moduleCommandInitializers = moduleCommandInitializers;
        this.recoveryManager = recoveryManager;
        this.stateTransferManager = stateTransferManager;
        this.lockManager = lockManager;
    }

    @Start(priority=1)
    public void start() {
        this.cacheName = this.cache.getName();
    }

    @Override
    public PutKeyValueCommand buildPutKeyValueCommand(Object key, Object value, long lifespanMillis, long maxIdleTimeMillis, Set<Flag> flags) {
        return new PutKeyValueCommand(key, value, false, this.notifier, lifespanMillis, maxIdleTimeMillis, flags);
    }

    @Override
    public VersionedPutKeyValueCommand buildVersionedPutKeyValueCommand(Object key, Object value, long lifespanMillis, long maxIdleTimeMillis, EntryVersion version, Set<Flag> flags) {
        return new VersionedPutKeyValueCommand(key, value, false, this.notifier, lifespanMillis, maxIdleTimeMillis, flags, version);
    }

    @Override
    public RemoveCommand buildRemoveCommand(Object key, Object value, Set<Flag> flags) {
        return new RemoveCommand(key, value, this.notifier, flags);
    }

    @Override
    public InvalidateCommand buildInvalidateCommand(Object ... keys) {
        return new InvalidateCommand(this.notifier, keys);
    }

    @Override
    public InvalidateCommand buildInvalidateFromL1Command(boolean forRehash, Object ... keys) {
        return new InvalidateL1Command(forRehash, this.dataContainer, this.configuration, this.distributionManager, this.notifier, keys);
    }

    @Override
    public InvalidateCommand buildInvalidateFromL1Command(boolean forRehash, Collection<Object> keys) {
        return new InvalidateL1Command(forRehash, this.dataContainer, this.configuration, this.distributionManager, this.notifier, keys);
    }

    @Override
    public ReplaceCommand buildReplaceCommand(Object key, Object oldValue, Object newValue, long lifespan, long maxIdleTimeMillis, Set<Flag> flags) {
        return new ReplaceCommand(key, oldValue, newValue, lifespan, maxIdleTimeMillis, flags);
    }

    @Override
    public SizeCommand buildSizeCommand() {
        if (this.cachedSizeCommand == null) {
            this.cachedSizeCommand = new SizeCommand(this.dataContainer);
        }
        return this.cachedSizeCommand;
    }

    @Override
    public KeySetCommand buildKeySetCommand() {
        if (this.cachedKeySetCommand == null) {
            this.cachedKeySetCommand = new KeySetCommand(this.dataContainer);
        }
        return this.cachedKeySetCommand;
    }

    @Override
    public ValuesCommand buildValuesCommand() {
        if (this.cachedValuesCommand == null) {
            this.cachedValuesCommand = new ValuesCommand(this.dataContainer);
        }
        return this.cachedValuesCommand;
    }

    @Override
    public EntrySetCommand buildEntrySetCommand() {
        if (this.cachedEntrySetCommand == null) {
            this.cachedEntrySetCommand = new EntrySetCommand(this.dataContainer);
        }
        return this.cachedEntrySetCommand;
    }

    @Override
    public GetKeyValueCommand buildGetKeyValueCommand(Object key, Set<Flag> flags) {
        return new GetKeyValueCommand(key, this.notifier, flags);
    }

    @Override
    public PutMapCommand buildPutMapCommand(Map map, long lifespan, long maxIdleTimeMillis, Set<Flag> flags) {
        return new PutMapCommand(map, this.notifier, lifespan, maxIdleTimeMillis, flags);
    }

    @Override
    public ClearCommand buildClearCommand(Set<Flag> flags) {
        return new ClearCommand(this.notifier, flags);
    }

    @Override
    public EvictCommand buildEvictCommand(Object key) {
        return new EvictCommand(key, this.notifier);
    }

    @Override
    public PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
        return new PrepareCommand(this.cacheName, gtx, modifications, onePhaseCommit);
    }

    @Override
    public VersionedPrepareCommand buildVersionedPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications) {
        return new VersionedPrepareCommand(this.cacheName, gtx, modifications);
    }

    @Override
    public CommitCommand buildCommitCommand(GlobalTransaction gtx) {
        return new CommitCommand(this.cacheName, gtx);
    }

    @Override
    public VersionedCommitCommand buildVersionedCommitCommand(GlobalTransaction gtx) {
        return new VersionedCommitCommand(this.cacheName, gtx);
    }

    @Override
    public RollbackCommand buildRollbackCommand(GlobalTransaction gtx) {
        return new RollbackCommand(this.cacheName, gtx);
    }

    @Override
    public MultipleRpcCommand buildReplicateCommand(List<ReplicableCommand> toReplicate) {
        return new MultipleRpcCommand(toReplicate, this.cacheName);
    }

    @Override
    public SingleRpcCommand buildSingleRpcCommand(ReplicableCommand call) {
        return new SingleRpcCommand(this.cacheName, call);
    }

    @Override
    public ClusteredGetCommand buildClusteredGetCommand(Object key, Set<Flag> flags, boolean acquireRemoteLock, GlobalTransaction gtx) {
        return new ClusteredGetCommand(key, this.cacheName, flags, acquireRemoteLock, gtx);
    }

    @Override
    public void initializeReplicableCommand(ReplicableCommand c, boolean isRemote) {
        if (c == null) {
            return;
        }
        switch (c.getCommandId()) {
            case 8: 
            case 28: {
                ((PutKeyValueCommand)c).init(this.notifier);
                break;
            }
            case 9: {
                ((PutMapCommand)c).init(this.notifier);
                break;
            }
            case 10: {
                ((RemoveCommand)c).init(this.notifier);
                break;
            }
            case 2: {
                MultipleRpcCommand rc = (MultipleRpcCommand)c;
                rc.init(this.interceptorChain, this.icc);
                if (rc.getCommands() == null) break;
                for (ReplicableCommand nested : rc.getCommands()) {
                    this.initializeReplicableCommand(nested, false);
                }
                break;
            }
            case 1: {
                SingleRpcCommand src = (SingleRpcCommand)c;
                src.init(this.interceptorChain, this.icc);
                if (src.getCommand() == null) break;
                this.initializeReplicableCommand(src.getCommand(), false);
                break;
            }
            case 6: {
                InvalidateCommand ic = (InvalidateCommand)c;
                ic.init(this.notifier);
                break;
            }
            case 7: {
                InvalidateL1Command ilc = (InvalidateL1Command)c;
                ilc.init(this.configuration, this.distributionManager, this.notifier, this.dataContainer);
                break;
            }
            case 12: 
            case 26: {
                PrepareCommand pc = (PrepareCommand)c;
                pc.init(this.interceptorChain, this.icc, this.txTable);
                pc.initialize(this.notifier, this.recoveryManager);
                if (pc.getModifications() != null) {
                    for (WriteCommand nested : pc.getModifications()) {
                        this.initializeReplicableCommand(nested, false);
                    }
                }
                pc.markTransactionAsRemote(isRemote);
                if (!this.configuration.isEnableDeadlockDetection() || !isRemote) break;
                DldGlobalTransaction transaction = (DldGlobalTransaction)pc.getGlobalTransaction();
                transaction.setLocksHeldAtOrigin(pc.getAffectedKeys());
                break;
            }
            case 14: 
            case 27: {
                CommitCommand commitCommand = (CommitCommand)c;
                commitCommand.init(this.interceptorChain, this.icc, this.txTable);
                commitCommand.markTransactionAsRemote(isRemote);
                break;
            }
            case 13: {
                RollbackCommand rollbackCommand = (RollbackCommand)c;
                rollbackCommand.init(this.interceptorChain, this.icc, this.txTable);
                rollbackCommand.markTransactionAsRemote(isRemote);
                break;
            }
            case 5: {
                ClearCommand cc = (ClearCommand)c;
                cc.init(this.notifier);
                break;
            }
            case 16: {
                ClusteredGetCommand clusteredGetCommand = (ClusteredGetCommand)c;
                clusteredGetCommand.initialize(this.icc, this, this.interceptorChain, this.distributionManager, this.txTable);
                break;
            }
            case 3: {
                DldGlobalTransaction gtx;
                RemoteTransaction transaction;
                LockControlCommand lcc = (LockControlCommand)c;
                lcc.init(this.interceptorChain, this.icc, this.txTable);
                lcc.markTransactionAsRemote(isRemote);
                if (!this.configuration.isEnableDeadlockDetection() || !isRemote || (transaction = this.txTable.getRemoteTransaction(gtx = (DldGlobalTransaction)lcc.getGlobalTransaction())) == null) break;
                if (!this.configuration.getCacheMode().isDistributed()) {
                    Set<Object> keys = this.txTable.getLockedKeysForRemoteTransaction(gtx);
                    GlobalTransaction gtx2 = transaction.getGlobalTransaction();
                    ((DldGlobalTransaction)gtx2).setLocksHeldAtOrigin(keys);
                    gtx.setLocksHeldAtOrigin(keys);
                    break;
                }
                GlobalTransaction gtx2 = transaction.getGlobalTransaction();
                ((DldGlobalTransaction)gtx2).setLocksHeldAtOrigin(gtx.getLocksHeldAtOrigin());
                break;
            }
            case 15: {
                StateTransferControlCommand rcc = (StateTransferControlCommand)c;
                rcc.init(this.stateTransferManager, this.configuration, this.dataContainer, this);
                break;
            }
            case 21: {
                GetInDoubtTransactionsCommand gptx = (GetInDoubtTransactionsCommand)c;
                gptx.init(this.recoveryManager);
                break;
            }
            case 22: {
                TxCompletionNotificationCommand ftx = (TxCompletionNotificationCommand)c;
                ftx.init(this.txTable, this.lockManager, this.recoveryManager);
                break;
            }
            case 20: {
                MapReduceCommand mrc = (MapReduceCommand)c;
                mrc.init(this, this.interceptorChain, this.icc, this.distributionManager, this.cache.getAdvancedCache().getRpcManager().getAddress());
                break;
            }
            case 19: {
                DistributedExecuteCommand dec = (DistributedExecuteCommand)c;
                dec.init(this.cache);
                break;
            }
            case 23: {
                GetInDoubtTxInfoCommand gidTxInfoCommand = (GetInDoubtTxInfoCommand)c;
                gidTxInfoCommand.init(this.recoveryManager);
                break;
            }
            case 24: {
                CompleteTransactionCommand ccc = (CompleteTransactionCommand)c;
                ccc.init(this.recoveryManager);
                break;
            }
            case 25: {
                ApplyDeltaCommand deltaCommand = (ApplyDeltaCommand)c;
                break;
            }
            default: {
                ModuleCommandInitializer mci = this.moduleCommandInitializers.get(c.getCommandId());
                if (mci != null) {
                    mci.initializeReplicableCommand(c, isRemote);
                    break;
                }
                if (!trace) break;
                log.tracef("Nothing to initialize for command: %s", c);
            }
        }
    }

    @Override
    public LockControlCommand buildLockControlCommand(Collection keys, Set<Flag> flags, GlobalTransaction gtx) {
        return new LockControlCommand(keys, this.cacheName, flags, gtx);
    }

    @Override
    public LockControlCommand buildLockControlCommand(Object key, Set<Flag> flags, GlobalTransaction gtx) {
        return new LockControlCommand(key, this.cacheName, flags, gtx);
    }

    @Override
    public LockControlCommand buildLockControlCommand(Collection keys, Set<Flag> flags) {
        return new LockControlCommand(keys, this.cacheName, flags, null);
    }

    @Override
    public StateTransferControlCommand buildStateTransferCommand(StateTransferControlCommand.Type type, Address sender, int viewId) {
        return new StateTransferControlCommand(this.cacheName, type, sender, viewId);
    }

    @Override
    public StateTransferControlCommand buildStateTransferCommand(StateTransferControlCommand.Type type, Address sender, int viewId, Collection<InternalCacheEntry> state) {
        return new StateTransferControlCommand(this.cacheName, type, sender, viewId, state);
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public GetInDoubtTransactionsCommand buildGetInDoubtTransactionsCommand() {
        return new GetInDoubtTransactionsCommand(this.cacheName);
    }

    @Override
    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(Xid xid, GlobalTransaction globalTransaction) {
        return new TxCompletionNotificationCommand(xid, globalTransaction, this.cacheName);
    }

    @Override
    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(long internalId) {
        return new TxCompletionNotificationCommand(internalId, this.cacheName);
    }

    @Override
    public <T> DistributedExecuteCommand<T> buildDistributedExecuteCommand(Callable<T> callable, Address sender, Collection keys) {
        return new DistributedExecuteCommand<T>(keys, callable);
    }

    @Override
    public MapReduceCommand buildMapReduceCommand(Mapper m, Reducer r, Address sender, Collection keys) {
        return new MapReduceCommand(m, r, this.cacheName, keys);
    }

    @Override
    public GetInDoubtTxInfoCommand buildGetInDoubtTxInfoCommand() {
        return new GetInDoubtTxInfoCommand(this.cacheName);
    }

    @Override
    public CompleteTransactionCommand buildCompleteTransactionCommand(Xid xid, boolean commit) {
        return new CompleteTransactionCommand(this.cacheName, xid, commit);
    }

    @Override
    public ApplyDeltaCommand buildApplyDeltaCommand(Object deltaAwareValueKey, Delta delta, Collection keys) {
        return new ApplyDeltaCommand(deltaAwareValueKey, delta, keys);
    }
}

