/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredGetCommand
extends BaseRpcCommand
implements FlagAffectedCommand {
    public static final byte COMMAND_ID = 16;
    private static final Log log = LogFactory.getLog(ClusteredGetCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Object key;
    private InvocationContextContainer icc;
    private CommandsFactory commandsFactory;
    private InterceptorChain invoker;
    private Boolean acquireRemoteLock;
    private GlobalTransaction gtx;
    private Set<Flag> flags;
    private DistributionManager distributionManager;
    private TransactionTable txTable;

    private ClusteredGetCommand() {
        super(null);
    }

    public ClusteredGetCommand(String cacheName) {
        super(cacheName);
    }

    public ClusteredGetCommand(Object key, String cacheName, Set<Flag> flags, boolean acquireRemoteLock, GlobalTransaction gtx) {
        super(cacheName);
        this.key = key;
        this.flags = flags;
        this.acquireRemoteLock = acquireRemoteLock;
        this.gtx = gtx;
        if (acquireRemoteLock && gtx == null) {
            throw new IllegalArgumentException("Cannot have null tx if we need to acquire locks");
        }
    }

    public ClusteredGetCommand(Object key, String cacheName) {
        this(key, cacheName, Collections.emptySet(), false, null);
    }

    public ClusteredGetCommand(String key, String cacheName, Set<Flag> flags) {
        this(key, cacheName, flags, false, null);
    }

    public void initialize(InvocationContextContainer icc, CommandsFactory commandsFactory, InterceptorChain interceptorChain, DistributionManager distributionManager, TransactionTable txTable) {
        this.distributionManager = distributionManager;
        this.icc = icc;
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
        this.txTable = txTable;
    }

    @Override
    public InternalCacheValue perform(InvocationContext context) throws Throwable {
        this.acquireLocksIfNeeded();
        if (this.distributionManager != null && this.distributionManager.isAffectedByRehash(this.key)) {
            return null;
        }
        EnumSet<Flag> commandFlags = EnumSet.of(Flag.SKIP_REMOTE_LOOKUP);
        if (this.flags != null) {
            commandFlags.addAll(this.flags);
        }
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(this.key, commandFlags);
        command.setReturnCacheEntry(true);
        InvocationContext invocationContext = this.icc.createRemoteInvocationContextForCommand(command, this.getOrigin());
        CacheEntry cacheEntry = (CacheEntry)this.invoker.invoke(invocationContext, command);
        if (cacheEntry == null) {
            if (trace) {
                log.trace("Did not find anything, returning null");
            }
            return null;
        }
        if (cacheEntry instanceof MVCCEntry) {
            if (trace) {
                log.trace("Handling an internal cache entry...");
            }
            MVCCEntry mvccEntry = (MVCCEntry)cacheEntry;
            return InternalEntryFactory.createValue(mvccEntry.getValue(), mvccEntry.getVersion(), -1L, mvccEntry.getLifespan(), -1L, mvccEntry.getMaxIdle());
        }
        InternalCacheEntry internalCacheEntry = (InternalCacheEntry)cacheEntry;
        return internalCacheEntry.toInternalCacheValue();
    }

    private void acquireLocksIfNeeded() throws Throwable {
        if (this.acquireRemoteLock.booleanValue()) {
            LockControlCommand lockControlCommand = this.commandsFactory.buildLockControlCommand(this.key, this.flags, this.gtx);
            lockControlCommand.init(this.invoker, this.icc, this.txTable);
            lockControlCommand.injectComponents(this.configuration, this.componentRegistry);
            lockControlCommand.perform(null);
        }
    }

    @Override
    public byte getCommandId() {
        return 16;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.flags, this.acquireRemoteLock, this.gtx};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        int i = 0;
        this.key = args[i++];
        this.flags = (Set)args[i++];
        this.acquireRemoteLock = (Boolean)args[i++];
        this.gtx = (GlobalTransaction)args[i];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetCommand that = (ClusteredGetCommand)o;
        return !(this.key == null ? that.key != null : !this.key.equals(that.key));
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        return result;
    }

    @Override
    public String toString() {
        return "ClusteredGetCommand{key=" + this.key + ", flags=" + this.flags + "}";
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public Set<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(Set<Flag> flags) {
        this.flags = flags;
    }
}

