/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.Set;
import org.infinispan.config.AbstractConfigurationBeanVisitor;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.SingletonStoreConfig;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ConfigurationValidatingVisitor
extends AbstractConfigurationBeanVisitor {
    private static final Log log = LogFactory.getLog(ConfigurationValidatingVisitor.class);
    private GlobalConfiguration.TransportType tt = null;
    private boolean evictionEnabled = false;
    private Configuration cfg;

    @Override
    public void visitSingletonStoreConfig(SingletonStoreConfig ssc) {
        if (this.tt == null && ssc.isSingletonStoreEnabled().booleanValue()) {
            throw new ConfigurationException("Singleton store configured without transport being configured");
        }
    }

    @Override
    public void visitTransportType(GlobalConfiguration.TransportType tt) {
        this.tt = tt;
    }

    @Override
    public void visitConfiguration(Configuration cfg) {
        this.cfg = cfg;
    }

    @Override
    public void visitClusteringType(Configuration.ClusteringType clusteringType) {
        Configuration.CacheMode mode = clusteringType.mode;
        Configuration.AsyncType async = clusteringType.async;
        Configuration.StateRetrievalType state = clusteringType.stateRetrieval;
        if (mode.isDistributed() && state.fetchInMemoryState.booleanValue()) {
            throw new ConfigurationException("Cache cannot use DISTRIBUTION mode and have fetchInMemoryState set to true.  Perhaps you meant to enable rehashing?");
        }
        if (mode.isDistributed() && async.useReplQueue.booleanValue()) {
            throw new ConfigurationException("Use of the replication queue is invalid when using DISTRIBUTED mode.");
        }
        if (mode.isSynchronous() && async.useReplQueue.booleanValue()) {
            throw new ConfigurationException("Use of the replication queue is only allowed with an ASYNCHRONOUS cluster mode.");
        }
        Set overriden = clusteringType.stateRetrieval.overriddenConfigurationElements;
        if (mode.isReplicated() && !state.isFetchInMemoryState().booleanValue() && !overriden.contains("fetchInMemoryState")) {
            log.debug("Cache is replicated but state transfer was not defined, so force enabling it");
            state.fetchInMemoryState(true);
        }
    }

    @Override
    public void visitL1Type(Configuration.L1Type l1Type) {
        boolean l1Enabled = l1Type.enabled;
        boolean l1OnRehash = l1Type.onRehash;
        if (!l1Enabled && l1OnRehash) {
            Set overridden = l1Type.overriddenConfigurationElements;
            if (overridden.contains("onRehash")) {
                throw new ConfigurationException("Can only move entries to L1 on rehash when L1 is enabled");
            }
            log.debug("L1 is disabled and L1OnRehash was not defined, disabling it");
            l1Type.onRehash(false);
        }
    }

    @Override
    public void visitCacheLoaderManagerConfig(CacheLoaderManagerConfig cacheLoaderManagerConfig) {
        boolean shared;
        if (!this.evictionEnabled && cacheLoaderManagerConfig.isPassivation().booleanValue()) {
            log.passivationWithoutEviction();
        }
        if (!(shared = cacheLoaderManagerConfig.isShared().booleanValue())) {
            for (CacheLoaderConfig loaderConfig : cacheLoaderManagerConfig.getCacheLoaderConfigs()) {
                if (!(loaderConfig instanceof CacheStoreConfig)) continue;
                CacheStoreConfig storeConfig = (CacheStoreConfig)loaderConfig;
                Boolean fetchPersistentState = storeConfig.isFetchPersistentState();
                Boolean purgeOnStartup = storeConfig.isPurgeOnStartup();
                if (fetchPersistentState.booleanValue() || purgeOnStartup.booleanValue() || !this.cfg.getCacheMode().isClustered()) continue;
                log.staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup();
            }
        }
    }

    @Override
    public void visitVersioningConfigurationBean(Configuration.VersioningConfigurationBean config) {
    }

    @Override
    public void visitEvictionType(Configuration.EvictionType et) {
        this.evictionEnabled = et.strategy.isEnabled();
        if (et.strategy.isEnabled() && et.maxEntries <= 0) {
            throw new ConfigurationException("Eviction maxEntries value cannot be less than or equal to zero if eviction is enabled");
        }
    }

    @Override
    public void visitQueryConfigurationBean(Configuration.QueryConfigurationBean qcb) {
        if (!qcb.enabled.booleanValue()) {
            return;
        }
        try {
            String clazz = "org.infinispan.query.Search";
            ClassLoader classLoader = this.cfg.getClassLoader();
            if (classLoader == null) {
                Class.forName(clazz);
            } else {
                classLoader.loadClass(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            log.warnf("Indexing can only be enabled if infinispan-query.jar is available on your classpath, and this jar has not been detected. Intended behavior may not be exhibited.", new Object[0]);
        }
    }
}

