/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.read.MapReduceCommand;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distexec.mapreduce.Collator;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.AbstractInProcessFuture;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MapReduceTask<KIn, VIn, KOut, VOut> {
    private static final Log log = LogFactory.getLog(MapReduceTask.class);
    private Mapper<KIn, VIn, KOut, VOut> mapper;
    private Reducer<KOut, VOut> reducer;
    private final Collection<KIn> keys;
    private final AdvancedCache<KIn, VIn> cache;
    protected final Marshaller marshaller;

    public MapReduceTask(Cache<KIn, VIn> masterCacheNode) {
        if (masterCacheNode == null) {
            throw new NullPointerException("Can not use " + masterCacheNode + " cache for MapReduceTask");
        }
        this.ensureProperCacheState(masterCacheNode.getAdvancedCache());
        this.cache = masterCacheNode.getAdvancedCache();
        this.keys = new LinkedList<KIn>();
        this.marshaller = this.cache.getComponentRegistry().getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> onKeys(KIn ... input) {
        for (KIn key : input) {
            this.keys.add(key);
        }
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> mappedWith(Mapper<KIn, VIn, KOut, VOut> mapper) {
        if (mapper == null) {
            throw new NullPointerException("A valid reference of Mapper is needed " + mapper);
        }
        this.mapper = mapper;
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> reducedWith(Reducer<KOut, VOut> reducer) {
        if (reducer == null) {
            throw new NullPointerException("A valid reference of Mapper is needed " + reducer);
        }
        this.reducer = reducer;
        return this;
    }

    public Map<KOut, VOut> execute() throws CacheException {
        if (this.mapper == null) {
            throw new NullPointerException("A valid reference of Mapper is not set " + this.mapper);
        }
        if (this.reducer == null) {
            throw new NullPointerException("A valid reference of Reducer is not set " + this.reducer);
        }
        ComponentRegistry registry = this.cache.getComponentRegistry();
        RpcManager rpc = this.cache.getRpcManager();
        InvocationContextContainer icc = this.cache.getInvocationContextContainer();
        DistributionManager dm = this.cache.getDistributionManager();
        InterceptorChain invoker = registry.getComponent(InterceptorChain.class);
        CommandsFactory factory = registry.getComponent(CommandsFactory.class);
        MapReduceCommand cmd = null;
        MapReduceCommand selfCmd = null;
        HashMap<Address, Response> results = new HashMap<Address, Response>();
        if (this.inputTaskKeysEmpty()) {
            selfCmd = cmd = factory.buildMapReduceCommand(this.mapper, this.reducer, rpc.getAddress(), this.keys);
            try {
                log.debugf("Invoking %s across entire cluster ", cmd);
                Map<Address, Response> map = rpc.invokeRemotely(null, (ReplicableCommand)cmd, true, false);
                log.debugf("Invoked %s across entire cluster, results are %s", cmd, map);
                results.putAll(map);
            }
            catch (Throwable e) {
                throw new CacheException("Could not invoke MapReduce task on remote nodes ", e);
            }
        } else {
            Map<Address, List<KIn>> keysToNodes = this.mapKeysToNodes();
            log.debugf("Keys to nodes mapping is " + keysToNodes, new Object[0]);
            ArrayList<MapReduceFuture> futures = new ArrayList<MapReduceFuture>();
            for (Map.Entry<Address, List<KIn>> e : keysToNodes.entrySet()) {
                Address address = e.getKey();
                List<KIn> keys = e.getValue();
                if (address.equals(rpc.getAddress())) {
                    selfCmd = factory.buildMapReduceCommand(this.clone(this.mapper), this.clone(this.reducer), rpc.getAddress(), keys);
                    continue;
                }
                cmd = factory.buildMapReduceCommand(this.mapper, this.reducer, rpc.getAddress(), keys);
                try {
                    log.debugf("Invoking %s on %s", cmd, address);
                    MapReduceFuture future = new MapReduceFuture();
                    futures.add(future);
                    rpc.invokeRemotelyInFuture(Collections.singleton(address), cmd, future);
                    log.debugf("Invoked %s on %s ", cmd, address);
                }
                catch (Exception ex) {
                    throw new CacheException("Could not invoke MapReduceTask on remote node " + address, ex);
                }
            }
            for (MapReduceFuture future : futures) {
                try {
                    Map result = (Map)future.get();
                    results.putAll(result);
                    log.debugf("Received result from future %s", result);
                }
                catch (Exception e1) {
                    throw new CacheException("Could not retrieve MapReduceTask result from remote node", e1);
                }
            }
        }
        boolean selfInvoke = selfCmd != null;
        Object localCommandResult = null;
        if (selfInvoke) {
            log.debugf("Invoking %s locally", cmd);
            selfCmd.init(factory, invoker, icc, dm, rpc.getAddress());
            try {
                localCommandResult = selfCmd.perform(null);
                log.debugf("Invoked %s locally", cmd);
            }
            catch (Throwable e1) {
                throw new CacheException("Could not invoke MapReduce task locally ", e1);
            }
        }
        HashMap reduceMap = new HashMap();
        for (Map.Entry e : results.entrySet()) {
            Response rsp = (Response)e.getValue();
            if (rsp.isSuccessful() && rsp.isValid()) {
                Map reducedResponse = (Map)((SuccessfulResponse)rsp).getResponseValue();
                this.groupKeys(reduceMap, reducedResponse);
                continue;
            }
            if (rsp instanceof ExceptionResponse) {
                throw new CacheException("MapReduce task on remote node " + e.getKey() + " threw Exception", ((ExceptionResponse)rsp).getException());
            }
            throw new CacheException("MapReduce task on remote node " + e.getKey() + " failed ");
        }
        if (selfInvoke) {
            this.groupKeys(reduceMap, (Map)localCommandResult);
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : reduceMap.entrySet()) {
            VOut reduced = this.reducer.reduce(entry.getKey(), ((List)entry.getValue()).iterator());
            result.put(entry.getKey(), reduced);
        }
        return result;
    }

    public Future<Map<KOut, VOut>> executeAsynchronously() {
        final Callable call = new Callable<Map<KOut, VOut>>(){

            @Override
            public Map<KOut, VOut> call() throws Exception {
                return MapReduceTask.this.execute();
            }
        };
        return new AbstractInProcessFuture<Map<KOut, VOut>>(){

            @Override
            public Map<KOut, VOut> get() throws InterruptedException, ExecutionException {
                try {
                    return (Map)call.call();
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }

    public <R> R execute(Collator<KOut, VOut, R> collator) {
        Map<KOut, VOut> execute = this.execute();
        return collator.collate(execute);
    }

    public <R> Future<R> executeAsynchronously(final Collator<KOut, VOut, R> collator) {
        final Callable call = new Callable<R>(){

            @Override
            public R call() throws Exception {
                return MapReduceTask.this.execute(collator);
            }
        };
        return new AbstractInProcessFuture<R>(){

            @Override
            public R get() throws InterruptedException, ExecutionException {
                try {
                    return call.call();
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }

    protected void groupKeys(Map<KOut, List<VOut>> finalReduced, Map<KOut, VOut> mapReceived) {
        for (Map.Entry<KOut, VOut> entry : mapReceived.entrySet()) {
            List<Object> l = null;
            if (!finalReduced.containsKey(entry.getKey())) {
                l = new LinkedList();
                finalReduced.put(entry.getKey(), l);
            } else {
                l = finalReduced.get(entry.getKey());
            }
            l.add(entry.getValue());
        }
    }

    protected Map<Address, List<KIn>> mapKeysToNodes() {
        DistributionManager dm = this.cache.getDistributionManager();
        HashMap<Address, List<KIn>> addressToKey = new HashMap<Address, List<KIn>>();
        for (KIn key : this.keys) {
            List<Address> nodesForKey = dm.locate(key);
            Address ownerOfKey = nodesForKey.get(0);
            ArrayList<KIn> keysAtNode = (ArrayList<KIn>)addressToKey.get(ownerOfKey);
            if (keysAtNode == null) {
                keysAtNode = new ArrayList<KIn>();
                addressToKey.put(ownerOfKey, keysAtNode);
            }
            keysAtNode.add(key);
        }
        return addressToKey;
    }

    protected Mapper<KIn, VIn, KOut, VOut> clone(Mapper<KIn, VIn, KOut, VOut> mapper) {
        return Util.cloneWithMarshaller(this.marshaller, mapper);
    }

    protected Reducer<KOut, VOut> clone(Reducer<KOut, VOut> reducer) {
        return Util.cloneWithMarshaller(this.marshaller, reducer);
    }

    private void ensureProperCacheState(AdvancedCache<KIn, VIn> cache) throws NullPointerException, IllegalStateException {
        if (cache.getRpcManager() == null) {
            throw new IllegalStateException("Can not use non-clustered cache for MapReduceTask");
        }
        if (cache.getStatus() != ComponentStatus.RUNNING) {
            throw new IllegalStateException("Invalid cache state " + (Object)((Object)cache.getStatus()));
        }
        if (cache.getDistributionManager() == null) {
            throw new IllegalStateException("Cache mode should be DIST, rather than " + cache.getConfiguration().getCacheModeString());
        }
    }

    private boolean inputTaskKeysEmpty() {
        return this.keys == null || this.keys.isEmpty();
    }

    private static class MapReduceFuture
    implements NotifyingNotifiableFuture<Object> {
        private Future<Object> futureResult;

        private MapReduceFuture() {
        }

        @Override
        public NotifyingFuture<Object> attachListener(FutureListener<Object> listener) {
            return this;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            return this.futureResult.get();
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.futureResult.get(timeout, unit);
        }

        @Override
        public void notifyDone() {
        }

        @Override
        public void setNetworkFuture(Future<Object> future) {
            this.futureResult = future;
        }
    }
}

